/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.feeds.record;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.auth.ClientInfo;
import org.sonatype.nexus.auth.NexusAuthorizationEvent;
import org.sonatype.nexus.auth.ResourceInfo;
import org.sonatype.nexus.configuration.application.NexusConfiguration;
import org.sonatype.nexus.events.Asynchronous;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.feeds.AuthcAuthzEvent;
import org.sonatype.nexus.feeds.record.AbstractFeedRecorderEventInspector;

@Named
@Singleton
public class NexusAuthorizationEventInspector
extends AbstractFeedRecorderEventInspector
implements EventSubscriber,
Asynchronous {
    private final NexusConfiguration nexusConfiguration;
    private volatile NexusAuthorizationEvent lastNexusAuthorizationEvent;

    @Inject
    public NexusAuthorizationEventInspector(NexusConfiguration nexusConfiguration) {
        this.nexusConfiguration = (NexusConfiguration)Preconditions.checkNotNull((Object)nexusConfiguration);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void inspect(NexusAuthorizationEvent nae) {
        if (!this.isRecordedEvent(nae)) {
            return;
        }
        this.lastNexusAuthorizationEvent = nae;
        ClientInfo ai = nae.getClientInfo();
        ResourceInfo ri = nae.getResourceInfo();
        String msg = "Unable to authorize user [" + ai.getUserid() + "] for " + ri.getAction() + "(" + ri.getAccessProtocol() + " method \"" + ri.getAccessMethod() + "\") to " + ri.getAccessedUri() + " from IP Address " + ai.getRemoteIP() + ", user agent:\"" + ai.getUserAgent() + "\"";
        this.log.debug(msg);
        AuthcAuthzEvent aae = new AuthcAuthzEvent(nae.getEventDate(), "AUTHZ", msg);
        String ip = ai.getRemoteIP();
        if (ip != null) {
            nae.getEventContext().put("request.address", ip);
        }
        this.getFeedRecorder().addAuthcAuthzEvent(aae);
    }

    protected boolean isRecordedEvent(NexusAuthorizationEvent nae) {
        if (nae.isSuccessful()) {
            return false;
        }
        if (StringUtils.equals((String)this.nexusConfiguration.getAnonymousUsername(), (String)nae.getClientInfo().getUserid())) {
            return false;
        }
        return !this.isSimilarEvent(nae);
    }

    protected boolean isSimilarEvent(NexusAuthorizationEvent nae) {
        return this.lastNexusAuthorizationEvent != null && this.lastNexusAuthorizationEvent.getClientInfo().equals((Object)nae.getClientInfo()) && this.lastNexusAuthorizationEvent.getResourceInfo().equals((Object)nae.getResourceInfo()) && System.currentTimeMillis() - this.lastNexusAuthorizationEvent.getEventDate().getTime() < 2000L;
    }
}

