/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.feeds.record;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.auth.ClientInfo;
import org.sonatype.nexus.auth.NexusAuthenticationEvent;
import org.sonatype.nexus.configuration.application.NexusConfiguration;
import org.sonatype.nexus.events.Asynchronous;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.feeds.AuthcAuthzEvent;
import org.sonatype.nexus.feeds.record.AbstractFeedRecorderEventInspector;

@Named
@Singleton
public class NexusAuthenticationEventInspector
extends AbstractFeedRecorderEventInspector
implements EventSubscriber,
Asynchronous {
    private final NexusConfiguration nexusConfiguration;
    private volatile NexusAuthenticationEvent lastNexusAuthenticationEvent;

    @Inject
    public NexusAuthenticationEventInspector(NexusConfiguration nexusConfiguration) {
        this.nexusConfiguration = (NexusConfiguration)Preconditions.checkNotNull((Object)nexusConfiguration);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void inspect(NexusAuthenticationEvent nae) {
        if (!this.isRecordedEvent(nae)) {
            return;
        }
        this.lastNexusAuthenticationEvent = nae;
        ClientInfo ai = nae.getClientInfo();
        String msg = String.format("%s user [%s] from IP address %s", nae.isSuccessful() ? "Successfully authenticated" : "Unable to authenticate", ai.getUserid(), StringUtils.defaultString((Object)ai.getRemoteIP(), (String)"[unknown]"));
        this.log.debug(msg);
        AuthcAuthzEvent aae = new AuthcAuthzEvent(nae.getEventDate(), "AUTHC", msg);
        String ip = ai.getRemoteIP();
        if (ip != null) {
            nae.getEventContext().put("request.address", ip);
        }
        this.getFeedRecorder().addAuthcAuthzEvent(aae);
    }

    protected boolean isRecordedEvent(NexusAuthenticationEvent nae) {
        if (StringUtils.equals((String)this.nexusConfiguration.getAnonymousUsername(), (String)nae.getClientInfo().getUserid())) {
            return false;
        }
        return !this.isSimilarEvent(nae);
    }

    protected boolean isSimilarEvent(NexusAuthenticationEvent nae) {
        return this.lastNexusAuthenticationEvent != null && this.lastNexusAuthenticationEvent.isSuccessful() == nae.isSuccessful() && this.lastNexusAuthenticationEvent.getClientInfo().equals((Object)nae.getClientInfo()) && System.currentTimeMillis() - this.lastNexusAuthenticationEvent.getEventDate().getTime() < 2000L;
    }
}

