/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.feeds.record;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.events.Asynchronous;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.feeds.NexusArtifactEvent;
import org.sonatype.nexus.feeds.record.AbstractFeedRecorderEventInspector;
import org.sonatype.nexus.feeds.record.NexusItemInfo;
import org.sonatype.nexus.proxy.events.RepositoryItemValidationEventFailed;
import org.sonatype.nexus.proxy.events.RepositoryItemValidationEventFailedChecksum;
import org.sonatype.nexus.proxy.events.RepositoryItemValidationEventFailedFileType;

@Named
@Singleton
public class ItemValidationFeedEventInspector
extends AbstractFeedRecorderEventInspector
implements EventSubscriber,
Asynchronous {
    @Subscribe
    @AllowConcurrentEvents
    public void inspect(RepositoryItemValidationEventFailed ievt) {
        NexusItemInfo ai = new NexusItemInfo();
        ai.setRepositoryId(ievt.getItem().getRepositoryId());
        ai.setPath(ievt.getItem().getPath());
        ai.setRemoteUrl(ievt.getItem().getRemoteUrl());
        String action = "broken";
        if (ievt instanceof RepositoryItemValidationEventFailedChecksum) {
            action = "brokenWRC";
        } else if (ievt instanceof RepositoryItemValidationEventFailedFileType) {
            action = "brokenIC";
        }
        NexusArtifactEvent nae = new NexusArtifactEvent(ievt.getEventDate(), action, ievt.getMessage(), ai);
        this.getFeedRecorder().addNexusArtifactEvent(nae);
    }
}

