/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.feeds.record;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.events.Asynchronous;
import org.sonatype.nexus.events.Event;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.feeds.FeedRecorder;
import org.sonatype.nexus.feeds.NexusArtifactEvent;
import org.sonatype.nexus.feeds.record.AbstractFeedRecorderEventInspector;
import org.sonatype.nexus.feeds.record.NexusItemInfo;
import org.sonatype.nexus.proxy.events.RepositoryItemEvent;
import org.sonatype.nexus.proxy.events.RepositoryItemEventCache;
import org.sonatype.nexus.proxy.events.RepositoryItemEventDelete;
import org.sonatype.nexus.proxy.events.RepositoryItemEventStore;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.uid.IsHiddenAttribute;
import org.sonatype.nexus.proxy.maven.uid.IsMavenArtifactSignatureAttribute;
import org.sonatype.nexus.proxy.maven.uid.IsMavenChecksumAttribute;
import org.sonatype.nexus.proxy.maven.uid.IsMavenRepositoryMetadataAttribute;

@Named
@Singleton
public class ItemChangesFeedEventInspector
extends AbstractFeedRecorderEventInspector
implements EventSubscriber,
Asynchronous {
    public ItemChangesFeedEventInspector() {
    }

    ItemChangesFeedEventInspector(FeedRecorder feedRecorder, ApplicationStatusSource applicationStatusSource) {
        super(feedRecorder, applicationStatusSource);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryItemEventCache evt) {
        this.inspectForNexus((Event<?>)evt);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryItemEventStore evt) {
        this.inspectForNexus((Event<?>)evt);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryItemEventDelete evt) {
        this.inspectForNexus((Event<?>)evt);
    }

    private void inspectForNexus(Event<?> evt) {
        RepositoryItemEvent ievt = (RepositoryItemEvent)evt;
        if (!(!StorageFileItem.class.isAssignableFrom(ievt.getItem().getClass()) || ievt.getItemUid().getBooleanAttributeValue(IsHiddenAttribute.class) || ievt.getItemUid().getBooleanAttributeValue(IsMavenRepositoryMetadataAttribute.class) || ievt.getItemUid().getBooleanAttributeValue(IsMavenArtifactSignatureAttribute.class) || ievt.getItemUid().getBooleanAttributeValue(IsMavenChecksumAttribute.class) || ((StorageFileItem)ievt.getItem()).isContentGenerated())) {
            String action;
            StorageFileItem pomItem = (StorageFileItem)ievt.getItem();
            NexusItemInfo ai = new NexusItemInfo();
            ai.setRepositoryId(pomItem.getRepositoryId());
            ai.setPath(pomItem.getPath());
            ai.setRemoteUrl(pomItem.getRemoteUrl());
            if (ievt instanceof RepositoryItemEventCache) {
                action = "cached";
            } else if (ievt instanceof RepositoryItemEventStore) {
                action = "deployed";
            } else if (ievt instanceof RepositoryItemEventDelete) {
                action = "deleted";
            } else {
                return;
            }
            NexusArtifactEvent nae = new NexusArtifactEvent(ievt.getEventDate(), action, "", ai);
            nae.addEventContext(ievt.getItemContext());
            nae.addItemAttributes(ievt.getItem().getRepositoryItemAttributes().asMap());
            this.getFeedRecorder().addNexusArtifactEvent(nae);
        }
    }
}

