/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.feeds.record;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.HashSet;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.Configurable;
import org.sonatype.nexus.configuration.ConfigurationChangeEvent;
import org.sonatype.nexus.events.Asynchronous;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.feeds.record.AbstractFeedRecorderEventInspector;

@Named
@Singleton
public class ConfigurationChangeEventInspector
extends AbstractFeedRecorderEventInspector
implements EventSubscriber,
Asynchronous {
    @Subscribe
    @AllowConcurrentEvents
    public void inspectForNexus(ConfigurationChangeEvent event) {
        if (event.getChanges().isEmpty()) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("Nexus server configuration was changed: ");
        HashSet<String> changes = new HashSet<String>();
        for (Configurable changed : event.getChanges()) {
            changes.add(changed.getName());
        }
        msg.append(changes.toString());
        if (event.getUserId() != null) {
            msg.append(", change was made by [" + event.getUserId() + "]");
        }
        this.getFeedRecorder().addSystemEvent("CONFIG", msg.toString());
    }
}

