/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.feeds;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.sonatype.nexus.feeds.SystemEvent;

public class SystemProcess
extends SystemEvent {
    private final Date started;
    private Status status;
    private Date finished;
    private String finishedMessage;
    private Throwable errorCause;

    public SystemProcess(Date eventDate, String action, String message, Date started) {
        super(eventDate, action, message);
        this.started = started;
        this.status = Status.STARTED;
    }

    public void finished(String message) {
        this.finished = new Date();
        this.status = Status.FINISHED;
        this.finishedMessage = message;
    }

    public void canceled(String message) {
        this.finished = new Date();
        this.status = Status.CANCELED;
        this.finishedMessage = message;
    }

    public void broken(Throwable e) {
        this.errorCause = e;
        this.finished = new Date();
        this.status = Status.BROKEN;
    }

    @Override
    public Date getEventDate() {
        if (this.finished == null) {
            return super.getEventDate();
        }
        return this.getFinished();
    }

    public Date getFinished() {
        return this.finished;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(super.getMessage());
        if (this.started != null) {
            sb.append(" : Process started on ");
            sb.append(this.started.toString());
            if (this.finished != null) {
                if (Status.BROKEN.equals((Object)this.status)) {
                    sb.append(", finished on ").append(this.finished.toString()).append(" with error.");
                    if (this.errorCause != null) {
                        sb.append(" Error message is: ").append(this.errorCause.getClass().getName());
                        if (this.errorCause.getMessage() != null) {
                            sb.append(", ").append(this.errorCause.getMessage());
                        }
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        this.errorCause.printStackTrace(pw);
                        sb.append(" Strack trace: ").append(sw.toString());
                    }
                } else if (Status.FINISHED.equals((Object)this.status)) {
                    sb.append(", finished successfully on ").append(this.finished.toString());
                } else if (Status.CANCELED.equals((Object)this.status)) {
                    sb.append(", canceled on ").append(this.finished.toString());
                }
            } else {
                sb.append(", not yet finished.");
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    static enum Status {
        STARTED,
        FINISHED,
        BROKEN,
        CANCELED;

    }
}

