/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.feeds;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.feeds.AuthcAuthzEvent;
import org.sonatype.nexus.feeds.FeedArtifactEventFilter;
import org.sonatype.nexus.feeds.FeedRecorder;
import org.sonatype.nexus.feeds.NexusArtifactEvent;
import org.sonatype.nexus.feeds.SystemEvent;
import org.sonatype.nexus.feeds.SystemProcess;
import org.sonatype.nexus.feeds.record.NexusItemInfo;
import org.sonatype.nexus.timeline.Entry;
import org.sonatype.nexus.timeline.EntryListCallback;
import org.sonatype.nexus.timeline.NexusTimeline;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultFeedRecorder
extends ComponentSupport
implements FeedRecorder {
    public static final int DEFAULT_PAGE_SIZE = 40;
    public static final String REPOSITORY = "r";
    public static final String REPOSITORY_PATH = "path";
    public static final String REMOTE_URL = "rurl";
    public static final String CTX_PREFIX = "ctx.";
    public static final String ATR_PREFIX = "atr.";
    public static final String ACTION = "action";
    public static final String MESSAGE = "message";
    public static final String DATE = "date";
    private static final String REPO_EVENT_TYPE = "REPO_EVENTS";
    private static final Set<String> REPO_EVENT_TYPE_SET = new HashSet<String>(1);
    private static final String SYSTEM_EVENT_TYPE = "SYSTEM";
    private static final Set<String> SYSTEM_EVENT_TYPE_SET = new HashSet<String>(1);
    private static final String AUTHC_AUTHZ_EVENT_TYPE = "AUTHC_AUTHZ";
    private static final Set<String> AUTHC_AUTHZ_EVENT_TYPE_SET = new HashSet<String>(1);
    private static final String EVENT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSSZ";
    private final NexusTimeline nexusTimeline;
    private final FeedArtifactEventFilter feedArtifactEventFilter;

    @Inject
    public DefaultFeedRecorder(NexusTimeline nexusTimeline, FeedArtifactEventFilter feedArtifactEventFilter) {
        REPO_EVENT_TYPE_SET.add(REPO_EVENT_TYPE);
        SYSTEM_EVENT_TYPE_SET.add(SYSTEM_EVENT_TYPE);
        AUTHC_AUTHZ_EVENT_TYPE_SET.add(AUTHC_AUTHZ_EVENT_TYPE);
        this.nexusTimeline = (NexusTimeline)Preconditions.checkNotNull((Object)nexusTimeline);
        this.feedArtifactEventFilter = (FeedArtifactEventFilter)Preconditions.checkNotNull((Object)feedArtifactEventFilter);
    }

    @Override
    public void shutdown() {
        this.nexusTimeline.shutdown();
    }

    protected DateFormat getDateFormat() {
        return new SimpleDateFormat(EVENT_DATE_FORMAT);
    }

    protected Date getEventDate(Map<String, String> map) {
        Date eventDate;
        try {
            eventDate = this.getDateFormat().parse(map.get(DATE));
        }
        catch (ParseException e) {
            this.log.warn("Could not format event date!", (Throwable)e);
            eventDate = new Date();
        }
        return eventDate;
    }

    protected List<NexusArtifactEvent> getAisFromMaps(List<Entry> data) {
        ArrayList<NexusArtifactEvent> result = new ArrayList<NexusArtifactEvent>();
        for (Entry record : data) {
            Map<String, String> map = record.getData();
            NexusItemInfo ai = new NexusItemInfo();
            ai.setRepositoryId(map.get(REPOSITORY));
            ai.setPath(map.get(REPOSITORY_PATH));
            ai.setRemoteUrl(map.get(REMOTE_URL));
            HashMap<String, String> ctx = new HashMap<String, String>();
            HashMap<String, String> atr = new HashMap<String, String>();
            for (String key : map.keySet()) {
                if (key.startsWith(CTX_PREFIX)) {
                    ctx.put(key.substring(4), map.get(key));
                    continue;
                }
                if (!key.startsWith(ATR_PREFIX)) continue;
                atr.put(key.substring(4), map.get(key));
            }
            NexusArtifactEvent nae = new NexusArtifactEvent(this.getEventDate(map), map.get(ACTION), map.get(MESSAGE), ai);
            if (atr.isEmpty()) {
                nae.addItemAttributes(ctx);
            } else {
                nae.addEventContext(ctx);
                nae.addItemAttributes(atr);
            }
            result.add(nae);
        }
        return this.feedArtifactEventFilter.filterArtifactEventList(result);
    }

    protected List<SystemEvent> getSesFromMaps(List<Entry> data) {
        ArrayList<SystemEvent> result = new ArrayList<SystemEvent>();
        for (Entry record : data) {
            Map<String, String> map = record.getData();
            HashMap<String, String> ctx = new HashMap<String, String>();
            for (String key : map.keySet()) {
                if (!key.startsWith(CTX_PREFIX)) continue;
                ctx.put(key.substring(4), map.get(key));
            }
            SystemEvent se = new SystemEvent(this.getEventDate(map), map.get(ACTION), map.get(MESSAGE));
            se.addEventContext(ctx);
            result.add(se);
        }
        return result;
    }

    protected List<AuthcAuthzEvent> getAaesFromMaps(List<Entry> data) {
        ArrayList<AuthcAuthzEvent> result = new ArrayList<AuthcAuthzEvent>();
        for (Entry record : data) {
            Map<String, String> map = record.getData();
            HashMap<String, String> ctx = new HashMap<String, String>();
            for (String key : map.keySet()) {
                if (!key.startsWith(CTX_PREFIX)) continue;
                ctx.put(key.substring(4), map.get(key));
            }
            AuthcAuthzEvent evt = new AuthcAuthzEvent(this.getEventDate(map), map.get(ACTION), map.get(MESSAGE));
            evt.addEventContext(ctx);
            result.add(evt);
        }
        return result;
    }

    public List<Entry> getEvents(Set<String> types, Set<String> subtypes, Integer from, Integer count, Predicate<Entry> filter) {
        int cnt = count != null ? count : 40;
        EntryListCallback cb = new EntryListCallback();
        if (from != null) {
            this.nexusTimeline.retrieve(from, cnt, types, subtypes, filter, cb);
        } else {
            this.nexusTimeline.retrieve(0, cnt, types, subtypes, filter, cb);
        }
        return cb.getEntries();
    }

    @Override
    public List<NexusArtifactEvent> getNexusArtifectEvents(Set<String> subtypes, Integer from, Integer count, Predicate<Entry> filter) {
        List<Entry> result = this.getEvents(REPO_EVENT_TYPE_SET, subtypes, from, count, filter);
        return this.getAisFromMaps(result);
    }

    @Override
    public List<SystemEvent> getSystemEvents(Set<String> subtypes, Integer from, Integer count, Predicate<Entry> filter) {
        List<Entry> result = this.getEvents(SYSTEM_EVENT_TYPE_SET, subtypes, from, count, filter);
        return this.getSesFromMaps(result);
    }

    @Override
    public List<AuthcAuthzEvent> getAuthcAuthzEvents(Set<String> subtypes, Integer from, Integer count, Predicate<Entry> filter) {
        List<Entry> result = this.getEvents(AUTHC_AUTHZ_EVENT_TYPE_SET, subtypes, from, count, filter);
        return this.getAaesFromMaps(result);
    }

    @Override
    public void addSystemEvent(String action, String message) {
        SystemEvent event = new SystemEvent(new Date(), action, message);
        this.addToTimeline(event);
    }

    private void putContext(Map<String, String> map, String prefix, Map<String, ?> context) {
        for (String key : context.keySet()) {
            Object value = context.get(key);
            if (value == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("The attribute with key '" + key + "' in event context is NULL!");
                }
                value = "";
            }
            map.put(prefix + key, value.toString());
        }
    }

    @Override
    public void addAuthcAuthzEvent(AuthcAuthzEvent evt) {
        HashMap<String, String> map = new HashMap<String, String>();
        this.putContext(map, CTX_PREFIX, evt.getEventContext());
        map.put(ACTION, evt.getAction());
        map.put(MESSAGE, evt.getMessage());
        map.put(DATE, this.getDateFormat().format(evt.getEventDate()));
        this.addToTimeline(map, AUTHC_AUTHZ_EVENT_TYPE, evt.getAction());
    }

    @Override
    public void addNexusArtifactEvent(NexusArtifactEvent nae) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(REPOSITORY, nae.getNexusItemInfo().getRepositoryId());
        map.put(REPOSITORY_PATH, nae.getNexusItemInfo().getPath());
        if (nae.getNexusItemInfo().getRemoteUrl() != null) {
            map.put(REMOTE_URL, nae.getNexusItemInfo().getRemoteUrl());
        }
        this.putContext(map, CTX_PREFIX, nae.getEventContext());
        this.putContext(map, ATR_PREFIX, nae.getItemAttributes());
        if (nae.getMessage() != null) {
            map.put(MESSAGE, nae.getMessage());
        }
        map.put(DATE, this.getDateFormat().format(nae.getEventDate()));
        map.put(ACTION, nae.getAction());
        this.addToTimeline(map, REPO_EVENT_TYPE, nae.getAction());
    }

    @Override
    public SystemProcess systemProcessStarted(String action, String message) {
        SystemProcess prc = new SystemProcess(new Date(), action, message, new Date());
        this.addToTimeline(prc);
        this.log.debug(prc.getMessage());
        return prc;
    }

    @Override
    public void systemProcessFinished(SystemProcess prc, String finishMessage) {
        prc.finished(finishMessage);
        this.addToTimeline(prc);
        this.log.debug(prc.getMessage());
    }

    @Override
    public void systemProcessCanceled(SystemProcess prc, String cancelMessage) {
        prc.canceled(cancelMessage);
        this.addToTimeline(prc);
        this.log.debug(prc.getMessage());
    }

    @Override
    public void systemProcessBroken(SystemProcess prc, Throwable e) {
        prc.broken(e);
        this.addToTimeline(prc);
        this.log.debug(prc.getMessage(), e);
    }

    protected void addToTimeline(SystemEvent se) {
        HashMap<String, String> map = new HashMap<String, String>();
        this.putContext(map, CTX_PREFIX, se.getEventContext());
        map.put(DATE, this.getDateFormat().format(se.getEventDate()));
        map.put(ACTION, se.getAction());
        map.put(MESSAGE, se.getMessage());
        this.addToTimeline(map, SYSTEM_EVENT_TYPE, se.getAction());
    }

    protected void addToTimeline(Map<String, String> map, String t1, String t2) {
        this.nexusTimeline.add(System.currentTimeMillis(), t1, t2, map);
    }
}

