/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.feeds;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.feeds.FeedArtifactEventFilter;
import org.sonatype.nexus.feeds.NexusArtifactEvent;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.access.NexusItemAuthorizer;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultFeedArtifactEventFilter
extends ComponentSupport
implements FeedArtifactEventFilter {
    private final NexusItemAuthorizer nexusItemAuthorizer;
    private final RepositoryRegistry repositoryRegistry;

    @Inject
    public DefaultFeedArtifactEventFilter(NexusItemAuthorizer nexusItemAuthorizer, RepositoryRegistry repositoryRegistry) {
        this.nexusItemAuthorizer = (NexusItemAuthorizer)Preconditions.checkNotNull((Object)nexusItemAuthorizer);
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
    }

    @Override
    public List<NexusArtifactEvent> filterArtifactEventList(List<NexusArtifactEvent> artifactEvents) {
        if (artifactEvents == null) {
            return null;
        }
        ArrayList<NexusArtifactEvent> filteredList = new ArrayList<NexusArtifactEvent>();
        for (NexusArtifactEvent nexusArtifactEvent : artifactEvents) {
            if (!this.filterEvent(nexusArtifactEvent)) continue;
            filteredList.add(nexusArtifactEvent);
        }
        return filteredList;
    }

    private boolean filterEvent(NexusArtifactEvent event) {
        try {
            Repository repo = this.repositoryRegistry.getRepository(event.getNexusItemInfo().getRepositoryId());
            ResourceStoreRequest req = new ResourceStoreRequest(event.getNexusItemInfo().getPath());
            if (!this.nexusItemAuthorizer.authorizePath(repo, req, Action.read)) {
                return false;
            }
        }
        catch (NoSuchRepositoryException e) {
            this.log.debug("Feed entry contained invalid repository id " + event.getNexusItemInfo().getRepositoryId(), (Throwable)e);
            return false;
        }
        return true;
    }
}

