/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.wonderland.rest;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.subject.Subject;
import org.jetbrains.annotations.NonNls;
import org.sonatype.nexus.util.Tokens;
import org.sonatype.nexus.wonderland.AuthTicketService;
import org.sonatype.nexus.wonderland.model.AuthTicketXO;
import org.sonatype.nexus.wonderland.model.AuthTokenXO;
import org.sonatype.security.SecuritySystem;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.siesta.common.Resource;
import org.sonatype.sisu.siesta.common.error.WebApplicationMessageException;

@Named
@Singleton
@Path(value="/wonderland/authenticate")
public class AuthenticateResource
extends ComponentSupport
implements Resource {
    @NonNls
    public static final String RESOURCE_URI = "/wonderland/authenticate";
    private final SecuritySystem security;
    private final AuthTicketService authTickets;

    public AuthenticateResource() {
        throw new Error();
    }

    @Inject
    public AuthenticateResource(SecuritySystem security, AuthTicketService authTickets) {
        this.security = (SecuritySystem)Preconditions.checkNotNull((Object)security);
        this.authTickets = (AuthTicketService)Preconditions.checkNotNull((Object)authTickets);
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public AuthTicketXO post(AuthTokenXO token) {
        String principalName;
        Preconditions.checkNotNull((Object)token);
        String username = Tokens.decodeBase64String((String)token.getU());
        String password = Tokens.decodeBase64String((String)token.getP());
        Subject subject = this.security.getSubject();
        Object principal = subject.getPrincipal();
        String string = principalName = principal == null ? "" : principal.toString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("payload username: {}, payload password: {}, principal: {}", new Object[]{username, Tokens.mask((String)password), principalName});
        }
        if (!principalName.equals(username)) {
            this.log.warn("auth token request denied - authenticated user {} does not match payload user {}", (Object)principalName, (Object)username);
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, "Username mismatch");
        }
        RealmSecurityManager sm = this.security.getSecurityManager();
        try {
            sm.authenticate((AuthenticationToken)new UsernamePasswordToken(username, password));
        }
        catch (AuthenticationException e) {
            this.log.trace("Authentication failed", (Throwable)e);
            throw new WebApplicationMessageException(Response.Status.FORBIDDEN, "Authentication failed");
        }
        return new AuthTicketXO().withT(this.authTickets.createTicket());
    }
}

