/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.wonderland.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.wonderland.AuthTicketService;
import org.sonatype.nexus.wonderland.internal.AuthTicketCache;
import org.sonatype.nexus.wonderland.internal.AuthTicketGenerator;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class AuthTicketServiceImpl
extends ComponentSupport
implements AuthTicketService {
    private final AuthTicketGenerator authTicketGenerator;
    private final AuthTicketCache authTicketCache;

    @Inject
    public AuthTicketServiceImpl(AuthTicketGenerator authTicketGenerator, AuthTicketCache authTicketCache) {
        this.authTicketGenerator = (AuthTicketGenerator)((Object)Preconditions.checkNotNull((Object)((Object)authTicketGenerator)));
        this.authTicketCache = (AuthTicketCache)((Object)Preconditions.checkNotNull((Object)((Object)authTicketCache)));
    }

    @Override
    public String createTicket() {
        String ticket = this.authTicketGenerator.generate();
        this.authTicketCache.add(ticket);
        return ticket;
    }

    @Override
    public boolean redeemTicket(String ticket) {
        Preconditions.checkNotNull((Object)ticket);
        return this.authTicketCache.remove(ticket);
    }
}

