/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.wonderland.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.jetbrains.annotations.NonNls;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.common.Mutex;
import org.sonatype.sisu.goodies.common.TestAccessible;
import org.sonatype.sisu.goodies.common.Time;

@Named
public class AuthTicketCache
extends ComponentSupport {
    @NonNls
    private static final String CPREFIX = "${wonderland.authTicketCache";
    private final Mutex lock = new Mutex();
    private final Map<String, Long> tokens = Maps.newHashMap();
    private final Time expireAfter;

    @Inject
    public AuthTicketCache(@Named(value="${wonderland.authTicketCache.expireAfter:-20s}") Time expireAfter) {
        this.expireAfter = (Time)Preconditions.checkNotNull((Object)expireAfter);
        this.log.debug("Expire after: {}", (Object)expireAfter);
    }

    @TestAccessible
    public AuthTicketCache() {
        this(Time.seconds((long)2L));
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private void expireTokens() {
        boolean trace = this.log.isTraceEnabled();
        long now = this.now();
        Iterator<Map.Entry<String, Long>> iter = this.tokens.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Long> entry = iter.next();
            if (!this.isTokenExpired(now, entry)) continue;
            iter.remove();
            if (!trace) continue;
            this.log.trace("Expired token: {}", (Object)entry.getKey());
        }
        if (trace && !this.tokens.isEmpty()) {
            this.log.trace("Valid tokens:");
            for (Map.Entry<String, Long> entry : this.tokens.entrySet()) {
                this.log.trace("  {}", (Object)entry.getKey());
            }
        }
    }

    @TestAccessible
    protected boolean isTokenExpired(long now, Map.Entry<String, Long> entry) {
        long diff = now - entry.getValue();
        return diff > this.expireAfter.toMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String token) {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            this.expireTokens();
            Preconditions.checkState((!this.tokens.containsKey(token) ? 1 : 0) != 0, (Object)"Duplicate token");
            this.tokens.put(token, this.now());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String token) {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            this.expireTokens();
            Long tmp = this.tokens.remove(token);
            return tmp != null;
        }
    }
}

