/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.template.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.common.io.Closer;
import org.sonatype.sisu.goodies.template.TemplateEngine;
import org.sonatype.sisu.goodies.template.TemplateParameters;

@Named(value="velocity")
public class VelocityTemplateEngine
extends ComponentSupport
implements TemplateEngine {
    private final Provider<VelocityEngine> velocityEngineProvider;

    @Inject
    public VelocityTemplateEngine(Provider<VelocityEngine> velocityEngineProvider) {
        this.velocityEngineProvider = (Provider)Preconditions.checkNotNull(velocityEngineProvider);
    }

    @Override
    public String render(Object owner, @NonNls URL template, @Nullable Map<String, Object> params) {
        String string;
        Preconditions.checkNotNull((Object)template);
        this.log.trace("Rendering template: {} w/params: {}", (Object)template, params);
        if (params == null) {
            params = Maps.newHashMap();
        }
        InputStreamReader input = null;
        try {
            input = new InputStreamReader(template.openStream());
            VelocityEngine engine = (VelocityEngine)this.velocityEngineProvider.get();
            params.put("owner", owner);
            StringWriter buff = new StringWriter();
            engine.evaluate((Context)new VelocityContext((Map)params), (Writer)buff, template.getFile(), (Reader)input);
            String result = buff.toString();
            this.log.trace("Result: {}", (Object)result);
            string = result;
        }
        catch (Exception e) {
            try {
                throw Throwables.propagate((Throwable)e);
            }
            catch (Throwable throwable) {
                Closer.close((Closeable[])new Closeable[]{input});
                throw throwable;
            }
        }
        Closer.close((Closeable[])new Closeable[]{input});
        return string;
    }

    @Override
    public String render(Object owner, URL template, TemplateParameters params) {
        Preconditions.checkNotNull((Object)params);
        return this.render(owner, template, params.get());
    }

    @Override
    public String render(Object owner, @NonNls String template, @Nullable Map<String, Object> params) {
        Preconditions.checkNotNull((Object)template);
        this.log.trace("Rendering template: {} w/params: {}", (Object)template, params);
        URL resource = owner.getClass().getResource(template);
        if (resource == null) {
            this.log.warn("Missing resource for template: {}; for owner: {}", (Object)template, (Object)owner.getClass().getName());
            return null;
        }
        return this.render(owner, resource, params);
    }

    @Override
    public String render(Object owner, @NonNls String template, TemplateParameters params) {
        Preconditions.checkNotNull((Object)params);
        return this.render(owner, template, params.get());
    }
}

