/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.template;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.NonNls;
import org.sonatype.sisu.goodies.template.TemplateAccessible;

public class TemplateThrowableAdapter {
    @NonNls
    public static final String NL = System.getProperty("line.separator");
    private final Throwable cause;

    public TemplateThrowableAdapter(Throwable cause) {
        this.cause = (Throwable)Preconditions.checkNotNull((Object)cause);
    }

    @TemplateAccessible
    public Throwable getCause() {
        return this.cause;
    }

    @TemplateAccessible
    public String getType() {
        return this.cause.getClass().getName();
    }

    @TemplateAccessible
    public String getSimpleType() {
        return this.cause.getClass().getSimpleName();
    }

    @TemplateAccessible
    public String getMessage() {
        return this.cause.getMessage();
    }

    @TemplateAccessible
    public String getTrace() {
        StringWriter buff = new StringWriter();
        this.cause.printStackTrace(new PrintWriter(buff));
        String tmp = buff.toString();
        return tmp.replace(NL, "<br/>");
    }

    public String toString() {
        return this.cause.toString();
    }
}

