/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.indextreeview;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.index.Field;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.treeview.TreeNode;
import org.apache.maven.index.treeview.TreeNodeFactory;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.index.IndexerManager;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.NoSuchRepositoryAccessException;
import org.sonatype.nexus.rest.index.AbstractIndexerNexusPlexusResource;
import org.sonatype.nexus.rest.indextreeview.IndexBrowserTreeNode;
import org.sonatype.nexus.rest.indextreeview.IndexBrowserTreeNodeDTO;
import org.sonatype.nexus.rest.indextreeview.IndexBrowserTreeNodeFactory;
import org.sonatype.nexus.rest.indextreeview.IndexBrowserTreeViewResponseDTO;
import org.sonatype.plexus.rest.resource.PlexusResourceException;

public abstract class AbstractIndexContentPlexusResource
extends AbstractIndexerNexusPlexusResource {
    private static final String HINT_GROUP_ID = "groupIdHint";
    private static final String HINT_ARTIFACT_ID = "artifactIdHint";
    private static final String HINT_VERSION = "versionHint";
    protected IndexerManager indexerManager;

    @Inject
    public void setIndexerManager(IndexerManager indexerManager) {
        this.indexerManager = indexerManager;
    }

    public Object getPayloadInstance() {
        return null;
    }

    @Override
    public void configureXStream(XStream xstream) {
        super.configureXStream(xstream);
        xstream.processAnnotations(IndexBrowserTreeNodeDTO.class);
        xstream.processAnnotations(IndexBrowserTreeViewResponseDTO.class);
    }

    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        String path = this.parsePathFromUri(request.getResourceRef().toString());
        if (!path.endsWith("/")) {
            response.redirectPermanent(path + "/");
            return null;
        }
        String groupIdHint = null;
        String artifactIdHint = null;
        String versionHint = null;
        Form form = request.getResourceRef().getQueryAsForm();
        if (form.getFirstValue(HINT_GROUP_ID) != null) {
            groupIdHint = form.getFirstValue(HINT_GROUP_ID);
        }
        if (form.getFirstValue(HINT_ARTIFACT_ID) != null) {
            artifactIdHint = form.getFirstValue(HINT_ARTIFACT_ID);
        }
        if (form.getFirstValue(HINT_VERSION) != null) {
            versionHint = form.getFirstValue(HINT_VERSION);
        }
        String repositoryId = this.getRepositoryId(request);
        try {
            Repository repository = this.getUnprotectedRepositoryRegistry().getRepository(repositoryId);
            if (GroupRepository.class.isInstance(repository) || repository.isSearchable()) {
                TreeNode node;
                IndexBrowserTreeNodeFactory factory = new IndexBrowserTreeNodeFactory(repository, this.createRedirectBaseRef(request).toString());
                HashMap<Field, String> hints = new HashMap<Field, String>();
                if (StringUtils.isNotBlank((String)groupIdHint)) {
                    hints.put(MAVEN.GROUP_ID, groupIdHint);
                }
                if (StringUtils.isNotBlank((String)artifactIdHint)) {
                    hints.put(MAVEN.ARTIFACT_ID, artifactIdHint);
                }
                if (StringUtils.isNotBlank((String)versionHint)) {
                    hints.put(MAVEN.VERSION, versionHint);
                }
                if ((node = this.indexerManager.listNodes((TreeNodeFactory)factory, path, hints, null, repository.getId())) == null) {
                    throw new PlexusResourceException(Status.CLIENT_ERROR_NOT_FOUND, (Object)"Unable to retrieve index tree nodes");
                }
                return new IndexBrowserTreeViewResponseDTO(((IndexBrowserTreeNode)node).toDTO());
            }
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "The index is disabled for this repository.");
        }
        catch (NoSuchRepositoryAccessException e) {
            this.getLogger().warn("Repository access denied, id=" + repositoryId);
            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN, "Access Denied to Repository");
        }
        catch (NoSuchRepositoryException e) {
            this.getLogger().error("Repository Not Found, id=" + repositoryId, (Throwable)e);
            throw new PlexusResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Repository Not Found", (Object)e);
        }
        catch (IOException e) {
            this.getLogger().error("Got IO exception while executing treeView, id=" + repositoryId, (Throwable)e);
            throw new PlexusResourceException(Status.SERVER_ERROR_INTERNAL, e.getMessage(), (Object)e);
        }
    }

    protected abstract String getRepositoryId(Request var1);

    protected String parsePathFromUri(String parsedPath) {
        int index;
        if (parsedPath.contains("?")) {
            parsedPath = parsedPath.substring(0, parsedPath.indexOf(63));
        }
        if (parsedPath.contains("#")) {
            parsedPath = parsedPath.substring(0, parsedPath.indexOf(35));
        }
        if (StringUtils.isEmpty((String)parsedPath)) {
            parsedPath = "/";
        }
        if ((index = parsedPath.indexOf("index_content")) > -1) {
            parsedPath = parsedPath.substring(index + "index_content".length());
        }
        return parsedPath;
    }
}

