/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.indexng;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.apache.lucene.queryParser.ParseException;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.SearchType;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.index.Searcher;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RepositoryKind;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.rest.index.AbstractIndexerNexusPlexusResource;
import org.sonatype.nexus.rest.indexng.GAHolder;
import org.sonatype.nexus.rest.indexng.StringVersion;
import org.sonatype.nexus.rest.model.NexusNGArtifact;
import org.sonatype.nexus.rest.model.NexusNGArtifactHit;
import org.sonatype.nexus.rest.model.NexusNGArtifactLink;
import org.sonatype.nexus.rest.model.NexusNGRepositoryDetail;
import org.sonatype.nexus.rest.model.SearchNGResponse;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResourceException;

@Named(value="SearchNGIndexPlexusResource")
@Singleton
@Path(value="/lucene/search")
public class SearchNGIndexPlexusResource
extends AbstractIndexerNexusPlexusResource {
    public static final String ROLE_HINT = "SearchNGIndexPlexusResource";
    private static final int LUCENE_HIT_LIMIT = 5000;
    private static final int DEFAULT_GA_HIT_LIMIT = 200;
    private static final int GA_HIT_LIMIT = SystemPropertiesHelper.getInteger((String)"plexus.search.ga.hit.limit", (int)200);
    private static final long DEFAULT_FIRST_LOOP_EXECUTION_TIME_LIMIT = 30000L;
    private static final long FIRST_LOOP_EXECUTION_TIME_LIMIT = SystemPropertiesHelper.getLong((String)"plexus.search.ga.firstLoopTime", (long)30000L);
    private static final int DEFAULT_DOCUMENT_RELEVANCE_HIT_CHANGE_THRESHOLD = 500;
    private static final float DOCUMENT_RELEVANCE_HIT_CHANGE_THRESHOLD = (float)SystemPropertiesHelper.getInteger((String)"plexus.search.ga.hit.relevanceDropThreshold", (int)500) / 1000.0f;
    private static final int DEFAULT_DOCUMENT_TOP_RELEVANCE_HIT_CHANGE_THRESHOLD = 750;
    private static final float DOCUMENT_TOP_RELEVANCE_HIT_CHANGE_THRESHOLD = (float)SystemPropertiesHelper.getInteger((String)"plexus.search.ga.hit.topRelevanceDropThreshold", (int)750) / 1000.0f;
    private static final int DEFAULT_COLLAPSE_OVERRIDE_TRESHOLD = 35;
    private static final int COLLAPSE_OVERRIDE_TRESHOLD = SystemPropertiesHelper.getInteger((String)"plexus.search.ga.collapseOverrideThreshold", (int)35);
    public static final String RESOURCE_URI = "/lucene/search";
    private Logger searchDiagnosticLogger = LoggerFactory.getLogger((String)"search.ng.diagnostic");
    private final List<Searcher> searchers;

    @Inject
    public SearchNGIndexPlexusResource(List<Searcher> searchers) {
        this.searchers = searchers;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:index]");
    }

    public Object getPayloadInstance() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @ResourceMethodSignature(queryParams={@QueryParam(value="q"), @QueryParam(value="g"), @QueryParam(value="a"), @QueryParam(value="v"), @QueryParam(value="p"), @QueryParam(value="c"), @QueryParam(value="cn"), @QueryParam(value="sha1"), @QueryParam(value="from"), @QueryParam(value="count"), @QueryParam(value="repositoryId")}, output=SearchNGResponse.class)
    public SearchNGResponse get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        SearchNGResponse searchNGResponse;
        Form form = request.getResourceRef().getQueryAsForm();
        HashMap<String, String> terms = new HashMap<String, String>();
        for (Parameter parameter : form) {
            terms.put(parameter.getName(), parameter.getValue());
        }
        Integer from = null;
        Boolean exact = null;
        String repositoryId = null;
        boolean expandVersion = false;
        boolean collapseResults = false;
        if (form.getFirstValue("from") != null) {
            try {
                from = Integer.valueOf(form.getFirstValue("from"));
            }
            catch (NumberFormatException e) {
                from = null;
            }
        }
        int count = 5000;
        if (form.getFirstValue("count") != null) {
            try {
                count = Math.min(5000, Integer.valueOf(form.getFirstValue("count")));
            }
            catch (NumberFormatException e) {
                count = 5000;
            }
        }
        if (form.getFirstValue("repositoryId") != null) {
            repositoryId = form.getFirstValue("repositoryId");
        }
        if (form.getFirstValue("exact") != null) {
            exact = Boolean.valueOf(form.getFirstValue("exact"));
        }
        if (form.getFirstValue("versionexpand") != null) {
            expandVersion = Boolean.valueOf(form.getFirstValue("versionexpand"));
        }
        if (form.getFirstValue("collapseresults") != null) {
            collapseResults = Boolean.valueOf(form.getFirstValue("collapseresults"));
        }
        boolean forceExpand = expandVersion || !collapseResults;
        IteratorSearchResponse searchResult = this.searchByTerms(terms, repositoryId, from, count, exact, this.searchers);
        try {
            SearchNGResponse searchResponse = this.packSearchNGResponse(request, terms, searchResult, forceExpand);
            searchResponse.setTotalCount(searchResult.getTotalHitsCount());
            searchResponse.setFrom(from == null ? -1 : from);
            searchResponse.setCount(count == 5000 ? -1 : count);
            searchNGResponse = searchResponse;
        }
        catch (Throwable throwable) {
            try {
                try {
                    searchResult.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ResourceException(Status.SERVER_ERROR_INTERNAL, e.getMessage(), (Throwable)e);
                }
            }
            catch (NoSuchRepositoryException e) {
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Repository to be searched does not exists!", (Throwable)e);
            }
        }
        searchResult.close();
        return searchNGResponse;
    }

    protected Logger getSearchDiagnosticLogger() {
        return this.searchDiagnosticLogger;
    }

    @VisibleForTesting
    IteratorSearchResponse searchByTerms(Map<String, String> terms, String repositoryId, Integer from, int count, Boolean exact, List<Searcher> searchers) throws NoSuchRepositoryException, ResourceException, IOException {
        try {
            Searcher searcher = null;
            for (Searcher _searcher : searchers) {
                if (!_searcher.canHandle(terms)) continue;
                searcher = _searcher;
            }
            if (searcher == null) {
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Requested search query is not supported");
            }
            SearchType searchType = searcher.getDefaultSearchType();
            if (exact != null) {
                searchType = exact != false ? SearchType.EXACT : SearchType.SCORED;
            }
            IteratorSearchResponse searchResponse = searcher.flatIteratorSearch(terms, repositoryId, from, count, null, false, searchType, null);
            return searchResponse;
        }
        catch (IllegalArgumentException e) {
            if (e.getCause() instanceof ParseException) {
                throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, e.getCause(), (Object)this.getNexusErrorResponse("search", e.getCause().getMessage()));
            }
            throw e;
        }
    }

    protected SearchNGResponse packSearchNGResponse(Request request, Map<String, String> terms, IteratorSearchResponse iterator, boolean forceExpand) {
        LinkedHashMap<String, GAHolder> gahits = new LinkedHashMap<String, GAHolder>();
        long startedAtMillis = System.currentTimeMillis();
        float firstDocumentScore = -1.0f;
        float lastDocumentScore = -1.0f;
        int gavcount = 0;
        boolean tooManyResults = false;
        for (ArtifactInfo ai : iterator) {
            Object repositoryHit;
            Object version;
            NexusNGArtifact versionHit;
            tooManyResults = true;
            if (System.currentTimeMillis() - startedAtMillis > FIRST_LOOP_EXECUTION_TIME_LIMIT) {
                this.getSearchDiagnosticLogger().debug("Stopping delivering search results since we spent more than " + FIRST_LOOP_EXECUTION_TIME_LIMIT + " millis in 1st loop processing results.");
                break;
            }
            if (gahits.size() > 10 && firstDocumentScore - ai.getLuceneScore() > DOCUMENT_TOP_RELEVANCE_HIT_CHANGE_THRESHOLD) {
                this.getSearchDiagnosticLogger().debug("Stopping delivering search results since we span " + DOCUMENT_TOP_RELEVANCE_HIT_CHANGE_THRESHOLD + " of score change (firstDocScore=" + firstDocumentScore + ", currentDocScore=" + ai.getLuceneScore() + ").");
                break;
            }
            if (gahits.size() > 10 && lastDocumentScore > 0.0f && lastDocumentScore - ai.getLuceneScore() > DOCUMENT_RELEVANCE_HIT_CHANGE_THRESHOLD) {
                this.getSearchDiagnosticLogger().debug("Stopping delivering search results since we hit a relevance drop bigger than " + DOCUMENT_RELEVANCE_HIT_CHANGE_THRESHOLD + " (lastDocScore=" + lastDocumentScore + ", currentDocScore=" + ai.getLuceneScore() + ").");
                break;
            }
            if (gahits.size() + 1 > GA_HIT_LIMIT) {
                this.getSearchDiagnosticLogger().debug("Stopping delivering search results since we hit a GA hit limit of " + GA_HIT_LIMIT + ".");
                break;
            }
            if (firstDocumentScore < 0.0f) {
                firstDocumentScore = ai.getLuceneScore();
            }
            lastDocumentScore = ai.getLuceneScore();
            String gakey = ai.groupId + ":" + ai.artifactId;
            GAHolder gaholder = (GAHolder)gahits.get(gakey);
            if (gaholder == null) {
                gaholder = new GAHolder();
                gahits.put(gakey, gaholder);
            }
            if ((versionHit = gaholder.getVersionHit((StringVersion)(version = new StringVersion(ai.version, ai.getArtifactVersion())))) == null) {
                versionHit = new NexusNGArtifact();
                versionHit.setGroupId(ai.groupId);
                versionHit.setArtifactId(ai.artifactId);
                versionHit.setVersion(ai.version);
                versionHit.setHighlightedFragment(this.getMatchHighlightHtmlSnippet(ai));
                gaholder.putVersionHit((StringVersion)version, versionHit);
                ++gavcount;
            }
            if ((repositoryHit = this.getRepositoryHit(versionHit, ai.repository)) == null) {
                repositoryHit = new NexusNGArtifactHit();
                repositoryHit.setRepositoryId(ai.repository);
                versionHit.addArtifactHit((NexusNGArtifactHit)repositoryHit);
                if (!"pom".equals(ai.packaging)) {
                    repositoryHit.addArtifactLink(this.createNexusNGArtifactLink(request, ai.repository, ai.groupId, ai.artifactId, ai.version, "pom", null));
                }
            }
            repositoryHit.addArtifactLink(this.createNexusNGArtifactLink(request, ai.repository, ai.groupId, ai.artifactId, ai.version, ai.fextension, ai.classifier));
            tooManyResults = false;
        }
        this.getSearchDiagnosticLogger().debug("Query terms \"" + terms + "\" (LQL \"" + iterator.getQuery() + "\") matched total of " + iterator.getTotalHitsCount() + " records, " + iterator.getTotalProcessedArtifactInfoCount() + " records were processed out of those, resulting in " + gahits.size() + " unique GA records. Lucene scored documents first=" + firstDocumentScore + ", last=" + lastDocumentScore + ". Main processing loop took " + (System.currentTimeMillis() - startedAtMillis) + " ms.");
        boolean expand = forceExpand || gavcount <= COLLAPSE_OVERRIDE_TRESHOLD;
        SearchNGResponse response = new SearchNGResponse();
        response.setTooManyResults(tooManyResults || iterator.getTotalHitsCount() + 1 >= 5000);
        response.setCollapsed(!expand);
        ArrayList<NexusNGArtifact> responseData = new ArrayList<NexusNGArtifact>();
        LinkedHashSet<String> repositoryIds = new LinkedHashSet<String>();
        for (GAHolder gahit : gahits.values()) {
            if (expand) {
                for (NexusNGArtifact artifact : gahit.getOrderedVersionHits()) {
                    responseData.add(artifact);
                    this.setLatest(artifact, gahit.getLatestRelease(), gahit.getLatestSnapshot());
                    this.addRepositoryIds(repositoryIds, artifact);
                }
                continue;
            }
            NexusNGArtifact artifact = gahit.getLatestVersionHit();
            this.setLatest(artifact, gahit.getLatestRelease(), gahit.getLatestSnapshot());
            responseData.add(artifact);
            this.addRepositoryIds(repositoryIds, artifact);
        }
        response.setData(responseData);
        ArrayList<NexusNGRepositoryDetail> repoDetails = new ArrayList<NexusNGRepositoryDetail>();
        for (String repositoryId : repositoryIds) {
            try {
                Repository repository = this.getUnprotectedRepositoryRegistry().getRepository(repositoryId);
                this.addRepositoryDetails(repoDetails, request, repository);
            }
            catch (NoSuchRepositoryException noSuchRepositoryException) {}
        }
        response.setRepoDetails(repoDetails);
        return response;
    }

    private NexusNGArtifactHit getRepositoryHit(NexusNGArtifact artifact, String repositoryId) {
        for (NexusNGArtifactHit repositoryHit : artifact.getArtifactHits()) {
            if (!repositoryId.equals(repositoryHit.getRepositoryId())) continue;
            return repositoryHit;
        }
        return null;
    }

    private void addRepositoryIds(LinkedHashSet<String> repositoryIds, NexusNGArtifact artifact) {
        for (NexusNGArtifactHit repositoryHit : artifact.getArtifactHits()) {
            repositoryIds.add(repositoryHit.getRepositoryId());
        }
    }

    private void setLatest(NexusNGArtifact artifact, NexusNGArtifact latestRelease, NexusNGArtifact latestSnapshot) {
        if (latestRelease != null) {
            artifact.setLatestRelease(latestRelease.getVersion());
            artifact.setLatestReleaseRepositoryId(((NexusNGArtifactHit)latestRelease.getArtifactHits().get(0)).getRepositoryId());
        }
        if (latestSnapshot != null) {
            artifact.setLatestSnapshot(latestSnapshot.getVersion());
            artifact.setLatestSnapshotRepositoryId(((NexusNGArtifactHit)latestSnapshot.getArtifactHits().get(0)).getRepositoryId());
        }
    }

    private void addRepositoryDetails(List<NexusNGRepositoryDetail> repoDetails, Request request, Repository repository) {
        boolean add = true;
        for (NexusNGRepositoryDetail repoDetail : repoDetails) {
            if (!repoDetail.getRepositoryId().equals(repository.getId())) continue;
            add = false;
            break;
        }
        if (add) {
            NexusNGRepositoryDetail repoDetail = new NexusNGRepositoryDetail();
            repoDetail.setRepositoryId(repository.getId());
            repoDetail.setRepositoryName(repository.getName());
            repoDetail.setRepositoryURL(this.createRepositoryReference(request, repository.getId()).getTargetRef().toString());
            repoDetail.setRepositoryContentClass(repository.getRepositoryContentClass().getId());
            repoDetail.setRepositoryKind(this.extractRepositoryKind(repository));
            MavenRepository mavenRepo = (MavenRepository)repository.adaptToFacet(MavenRepository.class);
            if (mavenRepo != null) {
                repoDetail.setRepositoryPolicy(mavenRepo.getRepositoryPolicy().name());
            }
            repoDetails.add(repoDetail);
        }
    }

    protected NexusNGArtifactLink createNexusNGArtifactLink(Request request, String repositoryId, String groupId, String artifactId, String version, String extension, String classifier) {
        NexusNGArtifactLink link = new NexusNGArtifactLink();
        link.setExtension(extension);
        link.setClassifier(classifier);
        return link;
    }

    protected String extractRepositoryKind(Repository repository) {
        RepositoryKind kind = repository.getRepositoryKind();
        if (kind.isFacetAvailable(HostedRepository.class)) {
            return "hosted";
        }
        if (kind.isFacetAvailable(ProxyRepository.class)) {
            return "proxy";
        }
        if (kind.isFacetAvailable(GroupRepository.class)) {
            return "group";
        }
        if (kind.isFacetAvailable(ShadowRepository.class)) {
            return "virtual";
        }
        return repository.getRepositoryKind().getMainFacet().getName();
    }
}

