/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.indexng;

import java.util.Collection;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.maven.index.artifact.VersionUtils;
import org.sonatype.nexus.rest.indexng.StringVersion;
import org.sonatype.nexus.rest.model.NexusNGArtifact;

class GAHolder {
    private final SortedMap<StringVersion, NexusNGArtifact> versionHits = new TreeMap(Collections.reverseOrder());
    private NexusNGArtifact latestSnapshot = null;
    private StringVersion latestSnapshotVersion = null;
    private NexusNGArtifact latestRelease = null;
    private StringVersion latestReleaseVersion = null;

    GAHolder() {
    }

    public NexusNGArtifact getVersionHit(StringVersion version) {
        return (NexusNGArtifact)this.versionHits.get(version);
    }

    public void putVersionHit(StringVersion version, NexusNGArtifact versionHit) {
        this.versionHits.put(version, versionHit);
        if (VersionUtils.isSnapshot((String)versionHit.getVersion())) {
            if (this.latestSnapshotVersion == null || this.latestSnapshotVersion.compareTo(version) < 0) {
                this.latestSnapshot = versionHit;
                this.latestSnapshotVersion = version;
            }
        } else if (this.latestReleaseVersion == null || this.latestReleaseVersion.compareTo(version) < 0) {
            this.latestRelease = versionHit;
            this.latestReleaseVersion = version;
        }
    }

    public NexusNGArtifact getLatestRelease() {
        return this.latestRelease;
    }

    public NexusNGArtifact getLatestSnapshot() {
        return this.latestSnapshot;
    }

    public Collection<NexusNGArtifact> getOrderedVersionHits() {
        return this.versionHits.values();
    }

    public NexusNGArtifact getLatestVersionHit() {
        return this.latestRelease != null ? this.latestRelease : this.latestSnapshot;
    }
}

