/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.index.artifact;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IteratorSearchResponse;
import org.restlet.data.Request;
import org.sonatype.nexus.index.IndexerManager;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.RepositoryNotAvailableException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.AccessManager;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.attributes.inspectors.DigestCalculatingInspector;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.AbstractArtifactViewProvider;
import org.sonatype.nexus.rest.NoSuchRepositoryAccessException;
import org.sonatype.nexus.rest.model.ArtifactInfoResource;
import org.sonatype.nexus.rest.model.ArtifactInfoResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryUrlResource;
import org.sonatype.plexus.rest.ReferenceFactory;

@Named(value="info")
@Singleton
public class InfoArtifactViewProvider
extends AbstractArtifactViewProvider {
    private final IndexerManager indexerManager;
    private final RepositoryRegistry protectedRepositoryRegistry;
    private final RepositoryRegistry repositoryRegistry;
    private final ReferenceFactory referenceFactory;
    private final AccessManager accessManager;

    @Inject
    public InfoArtifactViewProvider(IndexerManager indexerManager, @Named(value="protected") RepositoryRegistry protectedRepositoryRegistry, RepositoryRegistry repositoryRegistry, ReferenceFactory referenceFactory, AccessManager accessManager) {
        this.indexerManager = indexerManager;
        this.protectedRepositoryRegistry = protectedRepositoryRegistry;
        this.repositoryRegistry = repositoryRegistry;
        this.referenceFactory = referenceFactory;
        this.accessManager = accessManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object retrieveView(ResourceStoreRequest request, RepositoryItemUid itemUid, StorageItem item, Request req) throws IOException {
        String checksum;
        StorageFileItem fileItem = (StorageFileItem)item;
        LinkedHashSet<String> repositories = new LinkedHashSet<String>();
        repositories.add(itemUid.getRepository().getId());
        String string = checksum = fileItem == null ? null : fileItem.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_SHA1_KEY);
        if (checksum != null) {
            try (IteratorSearchResponse searchResponse = null;){
                searchResponse = this.indexerManager.searchArtifactSha1ChecksumIterator(checksum, null, null, null, null, null);
                for (ArtifactInfo info : searchResponse) {
                    repositories.add(info.repository);
                }
            }
        }
        for (Repository repo : this.protectedRepositoryRegistry.getRepositories()) {
            if (repositories.contains(repo.getId())) continue;
            ResourceStoreRequest repoRequest = new ResourceStoreRequest(itemUid.getPath(), request.isRequestLocalOnly(), request.isRequestRemoteOnly());
            if (!repo.getLocalStorage().containsItem(repo, repoRequest)) continue;
            try {
                StorageItem repoItem = repo.retrieveItem(repoRequest);
                if (checksum != null && !checksum.equals(repoItem.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_SHA1_KEY))) continue;
                repositories.add(repo.getId());
            }
            catch (AccessDeniedException e) {
            }
            catch (RepositoryNotAvailableException e) {
                this.getLogger().trace("Repository not available; ignoring", (Throwable)e);
            }
            catch (Exception e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        }
        ArtifactInfoResourceResponse result = new ArtifactInfoResourceResponse();
        ArtifactInfoResource resource = new ArtifactInfoResource();
        resource.setRepositoryId(itemUid.getRepository().getId());
        resource.setRepositoryName(itemUid.getRepository().getName());
        resource.setRepositoryPath(itemUid.getPath());
        resource.setRepositories(this.createRepositoriesUrl(repositories, req, itemUid.getPath()));
        resource.setPresentLocally(fileItem != null);
        if (fileItem != null) {
            resource.setMd5Hash(fileItem.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_MD5_KEY));
            resource.setSha1Hash(checksum);
            resource.setLastChanged(fileItem.getModified());
            resource.setSize(fileItem.getLength());
            resource.setUploaded(fileItem.getCreated());
            resource.setUploader(fileItem.getRepositoryItemAttributes().get("request.user"));
            resource.setMimeType(fileItem.getMimeType());
            try {
                this.accessManager.decide(itemUid.getRepository(), request, Action.delete);
                resource.setCanDelete(true);
            }
            catch (AccessDeniedException e) {
                resource.setCanDelete(false);
            }
        }
        result.setData(resource);
        return result;
    }

    protected boolean dereferenceLinks() {
        return true;
    }

    private List<RepositoryUrlResource> createRepositoriesUrl(Set<String> repositories, Request req, String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        ArrayList<RepositoryUrlResource> urls = new ArrayList<RepositoryUrlResource>();
        for (String repositoryId : repositories) {
            RepositoryUrlResource repoUrl = new RepositoryUrlResource();
            try {
                this.protectedRepositoryRegistry.getRepository(repositoryId);
                repoUrl.setCanView(true);
            }
            catch (NoSuchRepositoryAccessException e) {
                repoUrl.setCanView(false);
            }
            catch (NoSuchRepositoryException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                continue;
            }
            repoUrl.setRepositoryId(repositoryId);
            try {
                repoUrl.setRepositoryName(this.repositoryRegistry.getRepository(repositoryId).getName());
            }
            catch (NoSuchRepositoryException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            repoUrl.setArtifactUrl(this.referenceFactory.createReference(req, "content/repositories/" + repositoryId + path).toString());
            repoUrl.setPath(path);
            urls.add(repoUrl);
        }
        return urls;
    }
}

