/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.index;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IteratorResultSet;
import org.apache.maven.index.MatchHighlight;
import org.restlet.data.Request;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.index.MIndexerXStreamConfiguratorLightweight;
import org.sonatype.nexus.rest.model.NexusArtifact;

public abstract class AbstractIndexerNexusPlexusResource
extends AbstractNexusPlexusResource {
    public void configureXStream(XStream xstream) {
        super.configureXStream(xstream);
        MIndexerXStreamConfiguratorLightweight.configureXStream((XStream)xstream);
    }

    protected Collection<NexusArtifact> ai2NaColl(Request request, Collection<ArtifactInfo> aic) {
        if (aic == null) {
            return null;
        }
        ArrayList<NexusArtifact> result = new ArrayList<NexusArtifact>();
        for (ArtifactInfo ai : aic) {
            NexusArtifact na = this.ai2Na(request, ai);
            if (na == null) continue;
            result.add(na);
        }
        return result;
    }

    protected Collection<NexusArtifact> ai2NaColl(Request request, IteratorResultSet aic) {
        ArrayList<NexusArtifact> result = new ArrayList<NexusArtifact>();
        if (aic != null) {
            for (ArtifactInfo ai : aic) {
                NexusArtifact na = this.ai2Na(request, ai);
                if (na == null) continue;
                result.add(na);
            }
        }
        return result;
    }

    protected String getMatchHighlightHtmlSnippet(ArtifactInfo ai) {
        if (ai.getMatchHighlights().size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (MatchHighlight mh : ai.getMatchHighlights()) {
                sb.append("<blockquote>").append(mh.getField().getDescription()).append("<UL>");
                for (String high : mh.getHighlightedMatch()) {
                    sb.append("<LI>").append(high).append("</LI>");
                }
                sb.append("</UL></blockquote>");
            }
            return sb.toString();
        }
        return null;
    }

    protected NexusArtifact ai2Na(Request request, ArtifactInfo ai) {
        if (ai == null) {
            return null;
        }
        NexusArtifact a = new NexusArtifact();
        a.setGroupId(ai.groupId);
        a.setArtifactId(ai.artifactId);
        a.setVersion(ai.version);
        a.setClassifier(ai.classifier);
        a.setPackaging(ai.packaging);
        a.setExtension(ai.fextension);
        a.setRepoId(ai.repository);
        a.setContextId(ai.context);
        a.setHighlightedFragment(this.getMatchHighlightHtmlSnippet(ai));
        if (ai.repository != null) {
            a.setPomLink(this.createPomLink(request, ai));
            a.setArtifactLink(this.createArtifactLink(request, ai));
            try {
                Repository repository = this.getUnprotectedRepositoryRegistry().getRepository(ai.repository);
                if (MavenRepository.class.isAssignableFrom(repository.getClass())) {
                    MavenRepository mavenRepository = (MavenRepository)repository;
                    Gav gav = new Gav(ai.groupId, ai.artifactId, ai.version, ai.classifier, mavenRepository.getArtifactPackagingMapper().getExtensionForPackaging(ai.packaging), null, null, null, false, null, false, null);
                    ResourceStoreRequest req = new ResourceStoreRequest(mavenRepository.getGavCalculator().gavToPath(gav));
                    a.setResourceURI(this.createRepositoryReference(request, ai.repository, req.getRequestPath()).toString());
                }
            }
            catch (NoSuchRepositoryException e) {
                this.getLogger().warn("No such repository: '" + ai.repository + "'.", (Throwable)e);
                return null;
            }
        }
        return a;
    }

    protected String createPomLink(Request request, ArtifactInfo ai) {
        if (StringUtils.isNotEmpty((String)ai.classifier)) {
            return "";
        }
        String suffix = "?r=" + ai.repository + "&g=" + ai.groupId + "&a=" + ai.artifactId + "&v=" + ai.version + "&e=pom";
        return this.createRedirectBaseRef(request).toString() + suffix;
    }

    protected String createArtifactLink(Request request, ArtifactInfo ai) {
        if (StringUtils.isEmpty((String)ai.packaging) || "pom".equals(ai.packaging)) {
            return "";
        }
        String suffix = "?r=" + ai.repository + "&g=" + ai.groupId + "&a=" + ai.artifactId + "&v=" + ai.version + "&e=" + ai.fextension;
        if (StringUtils.isNotBlank((String)ai.classifier)) {
            suffix = suffix + "&c=" + ai.classifier;
        }
        return this.createRedirectBaseRef(request).toString() + suffix;
    }
}

