/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.SearchType;
import org.apache.maven.index.UniqueArtifactFilterPostprocessor;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.index.KeywordSearcher;
import org.sonatype.nexus.index.MavenCoordinatesSearcher;
import org.sonatype.nexus.index.Searcher;
import org.sonatype.nexus.index.tasks.RepairIndexTask;
import org.sonatype.nexus.index.tasks.UpdateIndexTask;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.rest.index.AbstractIndexerNexusPlexusResource;
import org.sonatype.nexus.rest.model.NexusArtifact;
import org.sonatype.nexus.rest.model.SearchResponse;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesPathAwareTask;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.nexus.scheduling.NexusTask;

public abstract class AbstractIndexPlexusResource
extends AbstractIndexerNexusPlexusResource {
    private static final int HIT_LIMIT = 500;
    private static final int COLLAPSE_OVERRIDE_TRESHOLD = 35;
    public static final String DOMAIN = "domain";
    public static final String DOMAIN_REPOSITORIES = "repositories";
    public static final String DOMAIN_REPO_GROUPS = "repo_groups";
    public static final String TARGET_ID = "target";
    private NexusScheduler nexusScheduler;
    private List<Searcher> searchers;

    public AbstractIndexPlexusResource() {
        this.setModifiable(true);
    }

    @Inject
    public void setNexusScheduler(NexusScheduler nexusScheduler) {
        this.nexusScheduler = nexusScheduler;
    }

    @Inject
    public void setSearchers(List<Searcher> searchers) {
        this.searchers = searchers;
    }

    public Object getPayloadInstance() {
        return null;
    }

    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        Form form = request.getResourceRef().getQueryAsForm();
        HashMap<String, String> terms = new HashMap<String, String>();
        for (Parameter parameter : form) {
            terms.put(parameter.getName(), parameter.getValue());
        }
        Integer from = null;
        Integer count = null;
        Boolean exact = null;
        Boolean expandVersion = null;
        Boolean expandPackaging = null;
        Boolean expandClassifier = null;
        Boolean collapseResults = Boolean.FALSE;
        if (form.getFirstValue("from") != null) {
            try {
                from = Integer.valueOf(form.getFirstValue("from"));
            }
            catch (NumberFormatException e) {
                from = null;
            }
        }
        if (form.getFirstValue("count") != null) {
            try {
                count = Integer.valueOf(form.getFirstValue("count"));
            }
            catch (NumberFormatException e) {
                count = null;
            }
        }
        if (form.getFirstValue("exact") != null) {
            exact = Boolean.valueOf(form.getFirstValue("exact"));
        }
        if (form.getFirstValue("versionexpand") != null) {
            expandVersion = Boolean.valueOf(form.getFirstValue("versionexpand"));
        }
        if (form.getFirstValue("packagingexpand") != null) {
            expandPackaging = Boolean.valueOf(form.getFirstValue("packagingexpand"));
        }
        if (form.getFirstValue("classifierexpand") != null) {
            expandClassifier = Boolean.valueOf(form.getFirstValue("classifierexpand"));
        }
        if (form.getFirstValue("collapseresults") != null) {
            collapseResults = Boolean.valueOf(form.getFirstValue("collapseresults"));
        }
        IteratorSearchResponse searchResult = null;
        SearchResponse result = new SearchResponse();
        try {
            int countRequested = count == null ? 500 : count;
            searchResult = this.searchByTerms(terms, this.getRepositoryId(request), from, countRequested, exact, expandVersion, expandPackaging, expandClassifier, collapseResults);
            result.setTooManyResults(searchResult.getTotalHitsCount() > countRequested);
            result.setTotalCount(searchResult.getTotalHitsCount());
            result.setFrom(from == null ? -1 : from);
            result.setCount(count == null ? -1 : count);
            result.setData(new ArrayList<NexusArtifact>(this.ai2NaColl(request, searchResult.getResults())));
            if (collapseResults.booleanValue() && result.getData().size() < searchResult.getTotalHitsCount() && result.getData().size() < 35 && searchResult.getTotalHitsCount() < 500) {
                collapseResults = false;
            }
        }
        catch (NoSuchRepositoryException e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Repository with ID='" + this.getRepositoryId(request) + "' does not exists!", (Throwable)e);
        }
        catch (IOException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, e.getMessage(), (Throwable)e);
        }
        finally {
            if (searchResult != null) {
                try {
                    searchResult.close();
                }
                catch (IOException e) {
                    throw new ResourceException(Status.SERVER_ERROR_INTERNAL, e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    private IteratorSearchResponse searchByTerms(Map<String, String> terms, String repositoryId, Integer from, Integer count, Boolean exact, Boolean expandVersion, Boolean expandPackaging, Boolean expandClassifier, Boolean collapseResults) throws NoSuchRepositoryException, ResourceException, IOException {
        for (Searcher searcher : this.searchers) {
            IteratorSearchResponse searchResponse;
            if (!searcher.canHandle(terms)) continue;
            SearchType searchType = searcher.getDefaultSearchType();
            if (exact != null) {
                searchType = exact != false ? SearchType.EXACT : SearchType.SCORED;
            }
            ArrayList<ArtifactInfoFilter> filters = new ArrayList<ArtifactInfoFilter>();
            boolean uniqueRGA = false;
            if (collapseResults.booleanValue() && (searcher instanceof KeywordSearcher || searcher instanceof MavenCoordinatesSearcher)) {
                UniqueArtifactFilterPostprocessor filter = new UniqueArtifactFilterPostprocessor();
                filter.addField(MAVEN.GROUP_ID);
                filter.addField(MAVEN.ARTIFACT_ID);
                if (Boolean.TRUE.equals(expandVersion)) {
                    filter.addField(MAVEN.VERSION);
                }
                if (Boolean.TRUE.equals(expandPackaging)) {
                    filter.addField(MAVEN.PACKAGING);
                }
                if (Boolean.TRUE.equals(expandClassifier)) {
                    filter.addField(MAVEN.CLASSIFIER);
                }
                filters.add((ArtifactInfoFilter)filter);
                uniqueRGA = true;
            }
            if ((searchResponse = searcher.flatIteratorSearch(terms, repositoryId, from, count, 500, uniqueRGA, searchType, filters)) == null) continue;
            if (collapseResults.booleanValue() && searchResponse.getTotalHitsCount() < 35) {
                searchResponse.close();
                return this.searchByTerms(terms, repositoryId, from, count, exact, expandVersion, expandPackaging, expandClassifier, false);
            }
            return searchResponse;
        }
        throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Requested search query is not supported");
    }

    public void delete(Context context, Request request, Response response) throws ResourceException {
        AbstractNexusRepositoriesPathAwareTask task = this.getIsFullReindex() ? (AbstractNexusRepositoriesPathAwareTask)this.getNexusScheduler().createTaskInstance(RepairIndexTask.class) : (AbstractNexusRepositoriesPathAwareTask)this.getNexusScheduler().createTaskInstance(UpdateIndexTask.class);
        String repositoryId = this.getRepositoryId(request);
        if (repositoryId == null) {
            repositoryId = this.getRepositoryGroupId(request);
        }
        task.setRepositoryId(repositoryId);
        task.setResourceStorePath(this.getResourceStorePath(request));
        this.handleDelete((NexusTask<?>)task, request);
    }

    protected abstract boolean getIsFullReindex();

    protected NexusScheduler getNexusScheduler() {
        return this.nexusScheduler;
    }

    protected String getRepositoryId(Request request) throws ResourceException {
        String repoId = null;
        if (request.getAttributes().containsKey(DOMAIN) && request.getAttributes().containsKey(TARGET_ID) && DOMAIN_REPOSITORIES.equals(request.getAttributes().get(DOMAIN))) {
            repoId = request.getAttributes().get(TARGET_ID).toString();
            try {
                this.getRepositoryRegistry().getRepositoryWithFacet(repoId, Repository.class);
            }
            catch (NoSuchRepositoryException e) {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Repository not found!", (Throwable)e);
            }
        }
        return repoId;
    }

    protected String getRepositoryGroupId(Request request) throws ResourceException {
        String groupId = null;
        if (request.getAttributes().containsKey(DOMAIN) && request.getAttributes().containsKey(TARGET_ID) && DOMAIN_REPO_GROUPS.equals(request.getAttributes().get(DOMAIN))) {
            groupId = request.getAttributes().get(TARGET_ID).toString();
            try {
                this.getRepositoryRegistry().getRepositoryWithFacet(groupId, GroupRepository.class);
            }
            catch (NoSuchRepositoryException e) {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Repository group not found!", (Throwable)e);
            }
        }
        return groupId;
    }

    protected String getResourceStorePath(Request request) throws ResourceException {
        String path = null;
        if (this.getRepositoryId(request) != null || this.getRepositoryGroupId(request) != null) {
            path = request.getResourceRef().getRemainingPart();
            if (path.contains("?")) {
                path = path.substring(0, path.indexOf(63));
            }
            if (path.contains("#")) {
                path = path.substring(0, path.indexOf(35));
            }
            if (StringUtils.isEmpty((String)path)) {
                path = "/";
            }
        }
        return path;
    }

    public void handleDelete(NexusTask<?> task, Request request) throws ResourceException {
        try {
            if (this.getRepositoryGroupId(request) != null) {
                this.getRepositoryRegistry().getRepositoryWithFacet(this.getRepositoryGroupId(request), GroupRepository.class);
            } else if (this.getRepositoryId(request) != null) {
                try {
                    this.getRepositoryRegistry().getRepository(this.getRepositoryId(request));
                }
                catch (NoSuchRepositoryException e) {
                    this.getRepositoryRegistry().getRepositoryWithFacet(this.getRepositoryId(request), ShadowRepository.class);
                }
            }
            this.getNexusScheduler().submit("Internal", task);
            throw new ResourceException(Status.SUCCESS_NO_CONTENT);
        }
        catch (RejectedExecutionException e) {
            throw new ResourceException(Status.CLIENT_ERROR_CONFLICT, e.getMessage());
        }
        catch (NoSuchRepositoryException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, e.getMessage());
        }
    }
}

