/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.identify;

import java.io.IOException;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.maven.index.MAVEN;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.index.IndexerManager;
import org.sonatype.nexus.rest.index.AbstractIndexerNexusPlexusResource;
import org.sonatype.nexus.rest.model.NexusArtifact;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Path(value="/identify/{algorithm}/{hash}")
@Produces(value={"application/xml", "application/json"})
@Named(value="IdentifyHashPlexusResource")
@Singleton
public class IdentifyHashPlexusResource
extends AbstractIndexerNexusPlexusResource {
    public static final String ALGORITHM_KEY = "algorithm";
    public static final String HASH_KEY = "hash";
    public static final String RESOURCE_URI = "/identify/{algorithm}/{hash}";
    private final IndexerManager indexerManager;

    @Inject
    public IdentifyHashPlexusResource(IndexerManager indexerManager) {
        this.indexerManager = indexerManager;
    }

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/identify/*/*", "authcBasic,perms[nexus:identify]");
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="algorithm"), @PathParam(value="hash")}, output=NexusArtifact.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        String alg = request.getAttributes().get(ALGORITHM_KEY).toString();
        String checksum = request.getAttributes().get(HASH_KEY).toString();
        NexusArtifact na = null;
        try {
            Collection<NexusArtifact> nas;
            if ("sha1".equalsIgnoreCase(alg) && (nas = this.ai2NaColl(request, this.indexerManager.identifyArtifact(MAVEN.SHA1, checksum))) != null && nas.size() > 0) {
                na = nas.iterator().next();
            }
        }
        catch (IOException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "IOException during configuration retrieval!", (Throwable)e);
        }
        return na;
    }
}

