/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.util;

import java.util.Comparator;
import org.apache.maven.index.ArtifactInfo;

public class ArtifactInfoComparator
implements Comparator<ArtifactInfo> {
    private Comparator<String> stringComparator;

    public ArtifactInfoComparator() {
        this(String.CASE_INSENSITIVE_ORDER);
    }

    public ArtifactInfoComparator(Comparator<String> nameComparator) {
        this.stringComparator = nameComparator;
    }

    @Override
    public int compare(ArtifactInfo f1, ArtifactInfo f2) {
        int n = this.stringComparator.compare(f1.groupId, f2.groupId);
        if (n != 0) {
            return n;
        }
        n = this.stringComparator.compare(f1.artifactId, f2.artifactId);
        if (n != 0) {
            return n;
        }
        n = this.stringComparator.compare(f1.version, f2.version);
        if (n != 0) {
            return n;
        }
        String c1 = f1.classifier;
        String c2 = f2.classifier;
        if (c1 == null) {
            return c2 == null ? 0 : -1;
        }
        return c2 == null ? 1 : this.stringComparator.compare(c1, c2);
    }
}

