/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.treeview;

import org.apache.commons.lang.StringUtils;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.treeview.DefaultTreeNodeFactory;
import org.apache.maven.index.treeview.IndexTreeView;
import org.apache.maven.index.treeview.TreeNode;
import org.apache.maven.index.treeview.TreeViewRequest;
import org.slf4j.Logger;
import org.sonatype.nexus.index.treeview.DefaultMergedTreeNode;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.attributes.inspectors.DigestCalculatingInspector;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.sisu.goodies.common.Loggers;

public class DefaultMergedTreeNodeFactory
extends DefaultTreeNodeFactory {
    private static final String CHECK_LOCAL_AVAILABILITY_KEY = "org.sonatype.nexus.index.treeview.DefaultMergedTreeNodeFactory.checkLocalAvailability";
    private static final boolean CHECK_LOCAL_AVAILABILITY = SystemPropertiesHelper.getBoolean((String)"org.sonatype.nexus.index.treeview.DefaultMergedTreeNodeFactory.checkLocalAvailability", (boolean)false);
    private final Logger logger = Loggers.getLogger(((Object)((Object)this)).getClass());
    private final Repository repository;

    public DefaultMergedTreeNodeFactory(Repository repository) {
        super(repository.getId());
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    protected TreeNode decorateGNode(IndexTreeView tview, TreeViewRequest req, String path, String groupName, TreeNode node) {
        DefaultMergedTreeNode mnode = (DefaultMergedTreeNode)super.decorateGNode(tview, req, path, groupName, node);
        mnode.setLocallyAvailable(this.isPathAvailable(path));
        return mnode;
    }

    protected TreeNode decorateANode(IndexTreeView tview, TreeViewRequest req, ArtifactInfo ai, String path, TreeNode node) {
        DefaultMergedTreeNode mnode = (DefaultMergedTreeNode)super.decorateANode(tview, req, ai, path, node);
        mnode.setLocallyAvailable(this.isPathAvailable(path));
        return mnode;
    }

    protected TreeNode decorateVNode(IndexTreeView tview, TreeViewRequest req, ArtifactInfo ai, String path, TreeNode node) {
        DefaultMergedTreeNode mnode = (DefaultMergedTreeNode)super.decorateVNode(tview, req, ai, path, node);
        mnode.setLocallyAvailable(this.isPathAvailable(path));
        return mnode;
    }

    protected TreeNode decorateArtifactNode(IndexTreeView tview, TreeViewRequest req, ArtifactInfo ai, String path, TreeNode node) {
        DefaultMergedTreeNode mnode = (DefaultMergedTreeNode)super.decorateArtifactNode(tview, req, ai, path, node);
        this.gatherArtifactNodeInfoIfAvailable(path, mnode);
        return node;
    }

    protected TreeNode createNode(IndexTreeView tview, TreeViewRequest req, String path, boolean leaf, String nodeName, TreeNode.Type type) {
        TreeNode result = super.createNode(tview, req, path, leaf, nodeName, type);
        result.setRepositoryId(this.getRepository().getId());
        return result;
    }

    protected TreeNode instantiateNode(IndexTreeView tview, TreeViewRequest req, String path, boolean leaf, String nodeName) {
        return new DefaultMergedTreeNode(tview, req);
    }

    protected ResourceStoreRequest getResourceStoreRequest(String path) {
        return new ResourceStoreRequest(path, true);
    }

    protected boolean isPathAvailable(String path) {
        if (!CHECK_LOCAL_AVAILABILITY) {
            return false;
        }
        try {
            ResourceStoreRequest request = this.getResourceStoreRequest(path);
            return this.getRepository().getLocalStorage().containsItem(this.getRepository(), request);
        }
        catch (Exception e) {
            this.logger.warn("IO related problem during local storage availability check in repository {}", (Object)RepositoryStringUtils.getHumanizedNameString((Repository)this.getRepository()), (Object)e);
            return false;
        }
    }

    protected void gatherArtifactNodeInfoIfAvailable(String path, DefaultMergedTreeNode mnode) {
        if (!CHECK_LOCAL_AVAILABILITY) {
            return;
        }
        ResourceStoreRequest request = this.getResourceStoreRequest(path);
        mnode.setLocallyAvailable(false);
        try {
            StorageItem item = this.getRepository().retrieveItem(request);
            if (item instanceof StorageFileItem) {
                mnode.setLocallyAvailable(true);
                mnode.setArtifactTimestamp(item.getModified());
                mnode.setArtifactMd5Checksum(item.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_MD5_KEY));
                mnode.setArtifactSha1Checksum(item.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_SHA1_KEY));
                mnode.setInitiatorUserId(item.getRepositoryItemAttributes().get("request.user"));
                mnode.setInitiatorIpAddress(item.getRepositoryItemAttributes().get("request.address"));
                mnode.setArtifactOriginUrl(item.getRemoteUrl());
                if (!StringUtils.isEmpty((String)mnode.getArtifactOriginUrl())) {
                    mnode.setArtifactOriginReason("cached");
                } else {
                    mnode.setArtifactOriginReason("deployed");
                }
            }
        }
        catch (ItemNotFoundException item) {
        }
        catch (AccessDeniedException item) {
        }
        catch (IllegalOperationException e) {
            this.logger.warn("Illegal operation tried against repository {}", (Object)RepositoryStringUtils.getHumanizedNameString((Repository)this.getRepository()), (Object)e);
        }
        catch (StorageException e) {
            this.logger.warn("IO related problem in repository {}", (Object)RepositoryStringUtils.getHumanizedNameString((Repository)this.getRepository()), (Object)e);
        }
    }
}

