/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.tasks;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.index.IndexerManager;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesTask;

@Named(value="PublishIndexesTask")
public class PublishIndexesTask
extends AbstractNexusRepositoriesTask<Object> {
    public static final String ACTION = "PUBLISHINDEX";
    private final IndexerManager indexerManager;

    @Inject
    public PublishIndexesTask(IndexerManager indexerManager) {
        this.indexerManager = (IndexerManager)Preconditions.checkNotNull((Object)indexerManager);
    }

    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    protected Object doRun() throws Exception {
        try {
            if (this.getRepositoryId() != null) {
                this.indexerManager.publishRepositoryIndex(this.getRepositoryId());
            } else {
                this.indexerManager.publishAllIndex();
            }
        }
        catch (IOException e) {
            this.getLogger().error("Cannot publish indexes!", (Throwable)e);
        }
        return null;
    }

    protected String getAction() {
        return ACTION;
    }

    protected String getMessage() {
        if (this.getRepositoryId() != null) {
            return "Publishing indexes for repository " + this.getRepositoryName();
        }
        return "Publishing indexes for all registered repositories";
    }
}

