/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.tasks;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.index.IndexerManager;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesTask;

@Named(value="OptimizeIndexTask")
public class OptimizeIndexTask
extends AbstractNexusRepositoriesTask<Object> {
    public static final String ACTION = "OPTIMIZE_INDEX";
    private final IndexerManager indexManager;

    @Inject
    public OptimizeIndexTask(IndexerManager indexManager) {
        this.indexManager = (IndexerManager)Preconditions.checkNotNull((Object)indexManager);
    }

    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    public Object doRun() throws Exception {
        if (this.getRepositoryId() != null) {
            this.indexManager.optimizeRepositoryIndex(this.getRepositoryId());
        } else {
            this.indexManager.optimizeAllRepositoriesIndex();
        }
        return null;
    }

    protected String getAction() {
        return ACTION;
    }

    protected String getMessage() {
        if (this.getRepositoryId() != null) {
            return "Optimizing repository " + this.getRepositoryName() + " index.";
        }
        return "Optimizing all maven repositories indexes";
    }
}

