/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.tasks;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.index.IndexerManager;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesTask;

@Named(value="DownloadIndexesTask")
public class DownloadIndexesTask
extends AbstractNexusRepositoriesTask<Object> {
    public static final String ACTION = "DOWNLOADINDEX";
    private final IndexerManager indexerManager;

    @Inject
    public DownloadIndexesTask(IndexerManager indexerManager) {
        this.indexerManager = (IndexerManager)Preconditions.checkNotNull((Object)indexerManager);
    }

    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    protected Object doRun() throws Exception {
        if (this.getRepositoryId() != null) {
            this.indexerManager.downloadRepositoryIndex(this.getRepositoryId());
        } else {
            this.indexerManager.downloadAllIndex();
        }
        return null;
    }

    protected String getAction() {
        return ACTION;
    }

    protected String getMessage() {
        if (this.getRepositoryId() != null) {
            return "Downloading indexes for repository " + this.getRepositoryName();
        }
        return "Downloading indexes for all registered repositories";
    }
}

