/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.tasks;

import java.util.List;
import javax.inject.Inject;
import org.sonatype.nexus.index.tasks.ReindexTaskHandler;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesPathAwareTask;

public abstract class AbstractIndexerTask
extends AbstractNexusRepositoriesPathAwareTask<Object> {
    public static final String ACTION = "REINDEX";
    private List<ReindexTaskHandler> handlers;
    private String action;
    private boolean fullReindex;

    public AbstractIndexerTask(String action, boolean fullReindex) {
        this.action = action;
        this.fullReindex = fullReindex;
    }

    @Inject
    public void setReindexTaskHandlers(List<ReindexTaskHandler> handlers) {
        this.handlers = handlers;
    }

    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    protected String getRepositoryPathFieldId() {
        return "resourceStorePath";
    }

    public Object doRun() throws Exception {
        for (ReindexTaskHandler handler : this.handlers) {
            try {
                if (this.getRepositoryId() != null) {
                    handler.reindexRepository(this.getRepositoryId(), this.getResourceStorePath(), this.fullReindex);
                    continue;
                }
                handler.reindexAllRepositories(this.getResourceStorePath(), this.fullReindex);
            }
            catch (NoSuchRepositoryException nsre) {
                if (this.getRepositoryId() != null) {
                    this.getLogger().warn("Repository with ID=\"" + this.getRepositoryId() + "\" was not found. It's likely that the repository was deleted while either the repair or the update index task was running.");
                }
                throw nsre;
            }
        }
        return null;
    }

    protected String getAction() {
        return ACTION;
    }

    protected String getMessage() {
        if (this.getRepositoryId() != null) {
            return this.action + " repository index \"" + this.getRepositoryName() + "\" from path " + this.getResourceStorePath() + " and below.";
        }
        return this.action + " all registered repositories index";
    }
}

