/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.releaseremover;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.expr.SourcedSearchExpression;
import org.sonatype.aether.util.version.GenericVersionScheme;
import org.sonatype.aether.version.InvalidVersionSpecificationException;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionScheme;
import org.sonatype.nexus.index.DefaultIndexerManager;
import org.sonatype.nexus.maven.tasks.ReleaseRemovalRequest;
import org.sonatype.nexus.maven.tasks.ReleaseRemovalResult;
import org.sonatype.nexus.maven.tasks.ReleaseRemoverBackend;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.targets.Target;
import org.sonatype.nexus.util.PathUtils;
import org.sonatype.scheduling.TaskUtil;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named(value="index")
@Singleton
public class IndexReleaseRemoverBackend
extends ComponentSupport
implements ReleaseRemoverBackend {
    private final DefaultIndexerManager indexerManager;
    private final VersionScheme versionScheme;

    @Inject
    public IndexReleaseRemoverBackend(DefaultIndexerManager indexerManager) {
        this.indexerManager = (DefaultIndexerManager)Preconditions.checkNotNull((Object)indexerManager);
        this.versionScheme = new GenericVersionScheme();
    }

    public void removeReleases(ReleaseRemovalRequest request, ReleaseRemovalResult result, MavenRepository repository, Target target) throws IOException {
        TaskUtil.checkInterruption();
        int deletedFiles = 0;
        boolean successful = true;
        try {
            final HashSet groupIds = Sets.newHashSet();
            this.indexerManager.shared((Repository)repository, new DefaultIndexerManager.Runnable(){

                @Override
                public void run(IndexingContext context) throws IOException {
                    groupIds.addAll(context.getAllGroups());
                }
            });
            for (String groupId : groupIds) {
                TaskUtil.checkInterruption();
                HashSet artifactIds = Sets.newHashSet();
                Query groupIdQ = this.indexerManager.constructQuery(MAVEN.GROUP_ID, (SearchExpression)new SourcedSearchExpression(groupId));
                try (IteratorSearchResponse searchResponse = this.indexerManager.searchQueryIterator(groupIdQ, repository.getId(), null, null, null, false, null);){
                    for (ArtifactInfo ai : searchResponse) {
                        artifactIds.add(ai.artifactId);
                    }
                }
                for (String artifactId : artifactIds) {
                    TaskUtil.checkInterruption();
                    HashSet versions = Sets.newHashSet();
                    Query artifactIdQ = this.indexerManager.constructQuery(MAVEN.ARTIFACT_ID, (SearchExpression)new SourcedSearchExpression(artifactId));
                    BooleanQuery gaQ = new BooleanQuery();
                    gaQ.add(groupIdQ, BooleanClause.Occur.MUST);
                    gaQ.add(artifactIdQ, BooleanClause.Occur.MUST);
                    try (IteratorSearchResponse searchResponse = this.indexerManager.searchQueryIterator((Query)gaQ, repository.getId(), null, null, null, false, null);){
                        for (ArtifactInfo ai : searchResponse) {
                            try {
                                versions.add(this.versionScheme.parseVersion(ai.version));
                            }
                            catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {}
                        }
                    }
                    if (versions.size() <= request.getNumberOfVersionsToKeep()) continue;
                    ArrayList sortedVersions = Lists.newArrayList((Iterable)versions);
                    Collections.sort(sortedVersions);
                    List toDelete = sortedVersions.subList(0, versions.size() - request.getNumberOfVersionsToKeep());
                    this.log.debug("Will delete {}:{} versions: {}", new Object[]{groupId, artifactId, toDelete});
                    for (Version version : toDelete) {
                        TaskUtil.checkInterruption();
                        String gavPath = repository.getGavCalculator().gavToPath(new Gav(groupId, artifactId, version.toString()));
                        String vDirectory = PathUtils.getParentPath((String)gavPath);
                        try {
                            int deleted = this.mayDeleteVersion(target, repository, vDirectory);
                            this.log.debug("Deleted {} files from {}:{}:{} in {}", new Object[]{deleted, groupId, artifactId, version, repository});
                            deletedFiles += deleted;
                        }
                        catch (Exception e) {
                            successful = false;
                            this.log.warn("Could not delete {}:{}:{} in {}, skipping it", new Object[]{groupId, artifactId, version, repository, e});
                        }
                    }
                }
            }
        }
        catch (NoSuchRepositoryException e) {
            this.log.warn("Repository {} unavailable, bailing out", (Object)repository, (Object)e);
        }
        result.setDeletedFileCount(deletedFiles);
        result.setSuccessful(successful);
    }

    private int mayDeleteVersion(Target target, MavenRepository repository, String vDirectory) throws Exception {
        try {
            Collection potentiallyDeletable = repository.list(new ResourceStoreRequest(vDirectory));
            ArrayList mustNotBeDeleted = Lists.newArrayList();
            ArrayList mustBeDeleted = Lists.newArrayList();
            for (StorageItem item : potentiallyDeletable) {
                if (item instanceof StorageCollectionItem) {
                    mustNotBeDeleted.add(item);
                    continue;
                }
                if (target != null && !target.isPathContained(repository.getRepositoryContentClass(), item.getPath())) {
                    mustNotBeDeleted.add(item);
                    continue;
                }
                mustBeDeleted.add(item);
            }
            if (mustNotBeDeleted.isEmpty()) {
                repository.deleteItem(new ResourceStoreRequest(vDirectory));
                return potentiallyDeletable.size();
            }
            int deleted = 0;
            for (StorageItem item : mustBeDeleted) {
                try {
                    repository.deleteItemWithChecksums(new ResourceStoreRequest(item.getResourceStoreRequest()));
                    ++deleted;
                }
                catch (ItemNotFoundException itemNotFoundException) {}
            }
            return deleted;
        }
        catch (ItemNotFoundException e) {
            return 0;
        }
    }
}

