/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.mindexer;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.DefaultArtifactContextProducer;
import org.apache.maven.index.context.IndexingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.attributes.AttributeStorage;
import org.sonatype.nexus.proxy.attributes.Attributes;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.storage.local.fs.DefaultFSLocalRepositoryStorage;

@Named(value="default")
@Singleton
public class NexusArtifactContextProducer
extends DefaultArtifactContextProducer {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final RepositoryRegistry repositoryRegistry;

    @Inject
    public NexusArtifactContextProducer(RepositoryRegistry repositoryRegistry) {
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
    }

    public ArtifactContext getArtifactContext(IndexingContext context, File file) {
        ArtifactContext ac = super.getArtifactContext(context, file);
        if (ac != null && ac.getArtifactInfo().sha1 == null) {
            String itemPath = file.getPath();
            try {
                MavenProxyRepository proxyRepository = (MavenProxyRepository)this.repositoryRegistry.getRepositoryWithFacet(context.getRepositoryId(), MavenProxyRepository.class);
                File baseDir = this.getRepositoryLocalStorageFile((Repository)proxyRepository, "/");
                if (baseDir != null) {
                    String sha1;
                    AttributeStorage attributeStorage;
                    Attributes attributes;
                    if (!(itemPath = itemPath.substring(baseDir.getPath().length())).startsWith("/")) {
                        itemPath = "/" + itemPath;
                    }
                    if ((attributes = (attributeStorage = proxyRepository.getAttributesHandler().getAttributeStorage()).getAttributes(proxyRepository.createUid(itemPath))) != null && !Strings.isNullOrEmpty((String)(sha1 = attributes.get("digest.sha1")))) {
                        this.log.debug("ArtifactContext of {} enhanced with sha1={}", (Object)itemPath, (Object)sha1);
                        ac.getArtifactInfo().sha1 = sha1;
                    }
                }
            }
            catch (NoSuchRepositoryException e) {
                this.log.debug("Repository {} is not a maven proxy", (Object)context.getRepositoryId());
            }
            catch (IOException e) {
                this.log.warn("IO problem during retrieve of {}:{}", new Object[]{context.getRepositoryId(), itemPath, e});
            }
        }
        return ac;
    }

    @Nullable
    private File getRepositoryLocalStorageFile(Repository repository, String path) {
        if (repository.getLocalUrl() != null && repository.getLocalStorage() instanceof DefaultFSLocalRepositoryStorage) {
            try {
                return ((DefaultFSLocalRepositoryStorage)repository.getLocalStorage()).getBaseDir(repository, new ResourceStoreRequest(path));
            }
            catch (LocalStorageException e) {
                this.log.warn("Cannot get {} file from {} repository's LS", new Object[]{path, repository.getId(), e});
            }
        }
        return null;
    }
}

