/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.events;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.events.Event;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.index.IndexerManager;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.events.RepositoryConfigurationUpdatedEvent;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventAdd;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventRemove;
import org.sonatype.nexus.proxy.events.RepositoryRegistryRepositoryEvent;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class IndexingRepositoryRegistryRepositoryEventInspector
extends ComponentSupport
implements EventSubscriber {
    private final IndexerManager indexerManager;
    private final RepositoryRegistry repoRegistry;

    @Inject
    public IndexingRepositoryRegistryRepositoryEventInspector(IndexerManager indexerManager, RepositoryRegistry repoRegistry) {
        this.indexerManager = indexerManager;
        this.repoRegistry = repoRegistry;
    }

    protected IndexerManager getIndexerManager() {
        return this.indexerManager;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryRegistryRepositoryEvent evt) {
        this.inspect((Event<?>)evt);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryConfigurationUpdatedEvent evt) {
        this.inspect((Event<?>)evt);
    }

    protected void inspect(Event<?> evt) {
        Repository repository = null;
        if (evt instanceof RepositoryRegistryRepositoryEvent) {
            repository = ((RepositoryRegistryRepositoryEvent)evt).getRepository();
        } else if (evt instanceof RepositoryConfigurationUpdatedEvent) {
            repository = ((RepositoryConfigurationUpdatedEvent)evt).getRepository();
        }
        try {
            this.repoRegistry.getRepositoryWithFacet(repository.getId(), MavenRepository.class);
            this.inspectForIndexerManager(evt, repository);
        }
        catch (NoSuchRepositoryException e) {
            this.log.debug("Attempted to handle repository that isn't yet in registry");
        }
    }

    private void inspectForIndexerManager(Event<?> evt, Repository repository) {
        try {
            if (evt instanceof RepositoryRegistryEventAdd) {
                this.getIndexerManager().addRepositoryIndexContext(repository.getId());
            } else if (evt instanceof RepositoryRegistryEventRemove) {
                this.getIndexerManager().removeRepositoryIndexContext(((RepositoryRegistryEventRemove)evt).getRepository().getId(), true);
            } else if (evt instanceof RepositoryConfigurationUpdatedEvent) {
                this.getIndexerManager().updateRepositoryIndexContext(repository.getId());
            }
        }
        catch (Exception e) {
            this.log.error("Could not maintain indexing contexts!", (Throwable)e);
        }
    }
}

