/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.events;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.events.Asynchronous;
import org.sonatype.nexus.events.Event;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.index.tasks.RepairIndexTask;
import org.sonatype.nexus.index.tasks.UpdateIndexTask;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.events.RepositoryConfigurationUpdatedEvent;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventAdd;
import org.sonatype.nexus.proxy.events.RepositoryRegistryRepositoryEvent;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesPathAwareTask;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.nexus.scheduling.NexusTask;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class IndexingRepositoryRegistryRepositoryAsyncEventInspector
extends ComponentSupport
implements EventSubscriber,
Asynchronous {
    private final RepositoryRegistry repoRegistry;
    private final NexusScheduler nexusScheduler;
    private final ApplicationStatusSource applicationStatusSource;

    @Inject
    public IndexingRepositoryRegistryRepositoryAsyncEventInspector(RepositoryRegistry repoRegistry, NexusScheduler nexusScheduler, ApplicationStatusSource applicationStatusSource) {
        this.repoRegistry = repoRegistry;
        this.nexusScheduler = nexusScheduler;
        this.applicationStatusSource = applicationStatusSource;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryRegistryRepositoryEvent evt) {
        this.inspect((Event<?>)evt);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryConfigurationUpdatedEvent evt) {
        this.inspect((Event<?>)evt);
    }

    protected void inspect(Event<?> evt) {
        if (!this.applicationStatusSource.getSystemStatus().isNexusStarted()) {
            return;
        }
        Repository repository = null;
        if (evt instanceof RepositoryRegistryRepositoryEvent) {
            repository = ((RepositoryRegistryRepositoryEvent)evt).getRepository();
        } else if (evt instanceof RepositoryConfigurationUpdatedEvent) {
            repository = ((RepositoryConfigurationUpdatedEvent)evt).getRepository();
        }
        try {
            this.repoRegistry.getRepositoryWithFacet(repository.getId(), MavenRepository.class);
            this.inspectForIndexerManager(evt, repository);
        }
        catch (NoSuchRepositoryException e) {
            this.log.debug("Attempted to handle repository that isn't yet in registry");
        }
    }

    private void inspectForIndexerManager(Event<?> evt, Repository repository) {
        try {
            RepositoryConfigurationUpdatedEvent event;
            if (evt instanceof RepositoryRegistryEventAdd) {
                if (repository.isIndexable()) {
                    this.reindexRepo(repository, false, "Creating initial index, repositoryId=" + repository.getId());
                }
            } else if (evt instanceof RepositoryConfigurationUpdatedEvent && ((event = (RepositoryConfigurationUpdatedEvent)evt).isRemoteUrlChanged() || event.isDownloadRemoteIndexEnabled() || event.isMadeSearchable())) {
                String taskName = null;
                String logMessage = null;
                if (event.isRemoteUrlChanged()) {
                    taskName = this.append(taskName, "remote URL changed");
                    logMessage = this.append(logMessage, "remote URL changed");
                }
                if (event.isDownloadRemoteIndexEnabled()) {
                    taskName = this.append(taskName, "enabled download of indexes");
                    logMessage = this.append(logMessage, "enabled download of indexes");
                }
                if (event.isMadeSearchable()) {
                    taskName = this.append(taskName, "enabled searchable");
                    logMessage = this.append(logMessage, "enabled searchable");
                }
                taskName = taskName + ", repositoryId=" + event.getRepository().getId() + ".";
                logMessage = logMessage + " on repository \"" + event.getRepository().getName() + "\" (id=" + event.getRepository().getId() + "), doing full reindex of it.";
                this.reindexRepo(event.getRepository(), true, taskName);
                this.log.info(logMessage);
            }
        }
        catch (Exception e) {
            this.log.error("Could not maintain indexing contexts!", (Throwable)e);
        }
    }

    private void reindexRepo(Repository repository, boolean full, String taskName) {
        AbstractNexusRepositoriesPathAwareTask rt = full ? (AbstractNexusRepositoriesPathAwareTask)this.nexusScheduler.createTaskInstance(RepairIndexTask.class) : (AbstractNexusRepositoriesPathAwareTask)this.nexusScheduler.createTaskInstance(UpdateIndexTask.class);
        rt.setRepositoryId(repository.getId());
        this.nexusScheduler.submit(taskName, (NexusTask)rt);
    }

    private String append(String message, String append) {
        if (StringUtils.isBlank((String)message)) {
            return StringUtils.capitalize((String)append);
        }
        return message + ", " + append;
    }
}

