/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.events;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.events.Asynchronous;
import org.sonatype.nexus.events.Event;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.index.IndexerManager;
import org.sonatype.nexus.proxy.events.RepositoryItemEvent;
import org.sonatype.nexus.proxy.events.RepositoryItemEventCache;
import org.sonatype.nexus.proxy.events.RepositoryItemEventDelete;
import org.sonatype.nexus.proxy.events.RepositoryItemEventStore;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class IndexerManagerEventInspector
extends ComponentSupport
implements EventSubscriber,
Asynchronous {
    private final boolean enabled = SystemPropertiesHelper.getBoolean((String)"org.sonatype.nexus.events.IndexerManagerEventInspector.enabled", (boolean)true);
    private final IndexerManager indexerManager;

    @Inject
    public IndexerManagerEventInspector(IndexerManager indexerManager) {
        this.indexerManager = indexerManager;
    }

    protected IndexerManager getIndexerManager() {
        return this.indexerManager;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryItemEventCache evt) {
        if (this.enabled) {
            this.inspectForIndexerManager((Event<?>)evt);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryItemEventStore evt) {
        if (this.enabled) {
            this.inspectForIndexerManager((Event<?>)evt);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryItemEventDelete evt) {
        if (this.enabled) {
            this.inspectForIndexerManager((Event<?>)evt);
        }
    }

    private void inspectForIndexerManager(Event<?> evt) {
        RepositoryItemEvent ievt = (RepositoryItemEvent)evt;
        Repository repository = ievt.getRepository();
        if (repository != null && repository.isIndexable()) {
            try {
                if (ievt instanceof RepositoryItemEventCache || ievt instanceof RepositoryItemEventStore) {
                    this.getIndexerManager().addItemToIndex(repository, ievt.getItem());
                } else if (ievt instanceof RepositoryItemEventDelete) {
                    this.getIndexerManager().removeItemFromIndex(repository, ievt.getItem());
                }
            }
            catch (Exception e) {
                this.log.error("Could not maintain index for repository {}!", (Object)repository.getId(), (Object)e);
            }
        }
    }
}

