/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.SearchType;
import org.sonatype.nexus.index.IndexerManager;
import org.sonatype.nexus.index.Searcher;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;

@Named(value="sha1")
@Singleton
public class Sha1Searcher
implements Searcher {
    public static final String TERM_SHA1 = "sha1";
    private final IndexerManager indexerManager;

    @Inject
    public Sha1Searcher(IndexerManager indexerManager) {
        this.indexerManager = indexerManager;
    }

    @Override
    public boolean canHandle(Map<String, String> terms) {
        return terms.containsKey(TERM_SHA1) && !StringUtils.isEmpty((String)terms.get(TERM_SHA1));
    }

    @Override
    public SearchType getDefaultSearchType() {
        return SearchType.EXACT;
    }

    @Override
    public IteratorSearchResponse flatIteratorSearch(Map<String, String> terms, String repositoryId, Integer from, Integer count, Integer hitLimit, boolean uniqueRGA, SearchType searchType, List<ArtifactInfoFilter> filters) throws NoSuchRepositoryException {
        if (!this.canHandle(terms)) {
            return IteratorSearchResponse.empty(null);
        }
        return this.indexerManager.searchArtifactSha1ChecksumIterator(terms.get(TERM_SHA1), repositoryId, from, count, hitLimit, filters);
    }
}

