/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactScanningListener;
import org.apache.maven.index.ScanningResult;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.creator.MinimalArtifactInfoIndexCreator;
import org.sonatype.scheduling.TaskUtil;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public class NexusScanningListener
extends ComponentSupport
implements ArtifactScanningListener {
    private final IndexingContext context;
    private final IndexSearcher contextIndexSearcher;
    private final boolean fullReindex;
    private final boolean isProxy;
    private final Set<String> processedUinfos = new HashSet<String>();
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private int discovered;
    private int added;
    private int updated;
    private long scanningStarted;

    public NexusScanningListener(IndexingContext context, IndexSearcher contextIndexSearcher, boolean fullReindex, boolean isProxy) throws IOException {
        this.context = context;
        this.contextIndexSearcher = contextIndexSearcher;
        this.fullReindex = fullReindex;
        this.isProxy = isProxy;
        this.discovered = 0;
        this.added = 0;
        this.updated = 0;
    }

    public void scanningStarted(IndexingContext ctx) {
        this.log.info("Scanning of repositoryID=\"{}\" started.", (Object)this.context.getRepositoryId());
        this.scanningStarted = System.currentTimeMillis();
    }

    public void artifactDiscovered(ArtifactContext ac) {
        TaskUtil.checkInterruption();
        String uinfo = ac.getArtifactInfo().getUinfo();
        if (!this.processedUinfos.add(uinfo)) {
            return;
        }
        try {
            IndexOp indexOp = this.fullReindex && !this.isProxy ? this.index(ac) : this.update(ac);
            ++this.discovered;
            if (IndexOp.ADDED == indexOp) {
                ++this.added;
            } else if (IndexOp.UPDATED == indexOp) {
                ++this.updated;
            }
            for (Exception e : ac.getErrors()) {
                this.artifactError(ac, e);
            }
        }
        catch (Exception ex) {
            this.artifactError(ac, ex);
        }
    }

    public void scanningFinished(IndexingContext ctx, ScanningResult result) {
        TaskUtil.checkInterruption();
        int removed = 0;
        try {
            if (!this.fullReindex && !this.isProxy) {
                removed = this.removeDeletedArtifacts(result.getRequest().getStartingPath());
            }
            this.context.rebuildGroups();
            this.context.commit();
        }
        catch (IOException ex) {
            result.addException((Exception)ex);
        }
        result.setTotalFiles(this.discovered);
        result.setDeletedFiles(removed);
        result.getExceptions().addAll(this.exceptions);
        if (result.getDeletedFiles() > 0 || result.getTotalFiles() > 0) {
            try {
                this.context.updateTimestamp(true);
                this.context.optimize();
            }
            catch (Exception ex) {
                result.addException(ex);
            }
        }
        this.log.info("Scanning of repositoryID=\"{}\" finished: scanned={}, added={}, updated={}, removed={}, scanningDuration={}", new Object[]{this.context.getRepositoryId(), this.discovered, this.added, this.updated, removed, DurationFormatUtils.formatDurationHMS((long)(System.currentTimeMillis() - this.scanningStarted))});
    }

    public void artifactError(ArtifactContext ac, Exception e) {
        Exception exception = e;
        if (ac.getPom() != null || ac.getArtifact() != null) {
            StringBuilder sb = new StringBuilder("Found a problem while indexing");
            if (ac.getArtifact() != null) {
                sb.append(" artifact '" + ac.getArtifact().getAbsolutePath() + "'");
            }
            if (ac.getPom() != null) {
                sb.append(" pom '" + ac.getPom().getAbsolutePath() + "'");
            }
            exception = new Exception(sb.toString(), e);
        }
        this.exceptions.add(exception);
    }

    private int removeDeletedArtifacts(String contextPath) throws IOException {
        int deleted = 0;
        IndexReader r = this.contextIndexSearcher.getIndexReader();
        for (int i = 0; i < r.maxDoc(); ++i) {
            Document d;
            String uinfo;
            if (r.isDeleted(i) || (uinfo = (d = r.document(i)).get(ArtifactInfo.UINFO)) == null || this.processedUinfos.contains(uinfo)) continue;
            String[] ra = ArtifactInfo.FS_PATTERN.split(uinfo);
            ArtifactInfo ai = new ArtifactInfo();
            ai.repository = this.context.getRepositoryId();
            ai.groupId = ra[0];
            ai.artifactId = ra[1];
            ai.version = ra[2];
            if (ra.length > 3) {
                ai.classifier = ArtifactInfo.renvl((String)ra[3]);
            }
            if (ra.length > 4) {
                ai.packaging = ArtifactInfo.renvl((String)ra[4]);
            }
            ArtifactContext ac = new ArtifactContext(null, null, null, ai, ai.calculateGav());
            if (contextPath != null && !this.context.getGavCalculator().gavToPath(ac.getGav()).startsWith(contextPath) || IndexOp.DELETED != this.remove(ac)) continue;
            ++deleted;
        }
        return deleted;
    }

    private IndexOp index(ArtifactContext ac) throws IOException {
        Document d;
        if (ac != null && ac.getGav() != null && (d = ac.createDocument(this.context)) != null) {
            this.context.getIndexWriter().addDocument(d);
            return IndexOp.ADDED;
        }
        return IndexOp.NOOP;
    }

    private IndexOp update(ArtifactContext ac) throws IOException {
        Document d;
        if (ac != null && ac.getGav() != null && (d = ac.createDocument(this.context)) != null) {
            Document old = this.getOldDocument(ac);
            if (old == null) {
                this.context.getIndexWriter().addDocument(d);
                return IndexOp.ADDED;
            }
            if (!this.equals(d, old)) {
                this.context.getIndexWriter().updateDocument(new Term(ArtifactInfo.UINFO, ac.getArtifactInfo().getUinfo()), d);
                return IndexOp.UPDATED;
            }
        }
        return IndexOp.NOOP;
    }

    private IndexOp remove(ArtifactContext ac) throws IOException {
        if (ac != null) {
            String uinfo = ac.getArtifactInfo().getUinfo();
            Document doc = new Document();
            doc.add((Fieldable)new Field(ArtifactInfo.DELETED, uinfo, Field.Store.YES, Field.Index.NO));
            doc.add((Fieldable)new Field(ArtifactInfo.LAST_MODIFIED, Long.toString(System.currentTimeMillis()), Field.Store.YES, Field.Index.NO));
            IndexWriter w = this.context.getIndexWriter();
            w.addDocument(doc);
            w.deleteDocuments(new Term(ArtifactInfo.UINFO, uinfo));
            return IndexOp.DELETED;
        }
        return IndexOp.NOOP;
    }

    private boolean equals(Document d1, Document d2) {
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 == null || d2 == null) {
            return false;
        }
        Map<String, String> m1 = this.toMap(d1);
        Map<String, String> m2 = this.toMap(d2);
        m1.remove(MinimalArtifactInfoIndexCreator.FLD_LAST_MODIFIED.getKey());
        m2.remove(MinimalArtifactInfoIndexCreator.FLD_LAST_MODIFIED.getKey());
        boolean result = m1.equals(m2);
        if (!result) {
            this.log.trace("d1={}, d2={}", m1, m2);
        }
        return result;
    }

    private Map<String, String> toMap(Document d) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Object o : d.getFields()) {
            Fieldable f = (Fieldable)o;
            if (!f.isStored()) continue;
            result.put(f.name(), f.stringValue());
        }
        return result;
    }

    private Document getOldDocument(ArtifactContext ac) throws IOException {
        TopDocs result = this.contextIndexSearcher.search((Query)new TermQuery(new Term(ArtifactInfo.UINFO, ac.getArtifactInfo().getUinfo())), 2);
        if (result.totalHits == 1) {
            return this.contextIndexSearcher.doc(result.scoreDocs[0].doc);
        }
        return null;
    }

    public static enum IndexOp {
        NOOP,
        ADDED,
        UPDATED,
        DELETED;

    }
}

