/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.store.Directory;
import org.apache.maven.index.context.DefaultIndexingContext;
import org.apache.maven.index.context.ExistingLuceneIndexMismatchException;
import org.apache.maven.index.context.IndexCreator;

public class NexusIndexingContext
extends DefaultIndexingContext {
    private final boolean receivingUpdates;

    public NexusIndexingContext(String id, String repositoryId, File repository, Directory indexDirectory, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexCreators, boolean reclaimIndex, boolean receivingUpdates) throws IOException, ExistingLuceneIndexMismatchException {
        super(id, repositoryId, repository, indexDirectory, repositoryUrl, indexUpdateUrl, indexCreators, reclaimIndex);
        this.receivingUpdates = receivingUpdates;
    }

    protected IndexWriterConfig getWriterConfig() {
        IndexWriterConfig writerConfig = super.getWriterConfig();
        TieredMergePolicy mergePolicy = new TieredMergePolicy();
        mergePolicy.setUseCompoundFile(true);
        mergePolicy.setNoCFSRatio(1.0);
        writerConfig.setMergePolicy((MergePolicy)mergePolicy);
        return writerConfig;
    }

    public void optimize() throws IOException {
        super.optimize();
        this.releaseIndexSearcher(this.acquireIndexSearcher());
    }

    public boolean isReceivingUpdates() {
        return this.receivingUpdates;
    }
}

