/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NamedReadWriteLock
implements ReadWriteLock {
    private static final Logger log = LoggerFactory.getLogger(NamedReadWriteLock.class);
    private final Lock readLock;
    private final Lock writeLock;

    private NamedReadWriteLock(ReadWriteLock lock, String name) {
        this.readLock = new NamedLock(lock.readLock(), name, "S");
        this.writeLock = new NamedLock(lock.writeLock(), name, "X");
    }

    @Override
    public Lock readLock() {
        return this.readLock;
    }

    @Override
    public Lock writeLock() {
        return this.writeLock;
    }

    public static ReadWriteLock decorate(ReadWriteLock lock, String name) {
        if (log.isDebugEnabled()) {
            return new NamedReadWriteLock(lock, name);
        }
        return lock;
    }

    private static class NamedLock
    implements Lock {
        private final Lock lock;
        private final String mode;
        private final String name;

        public NamedLock(Lock lock, String name, String mode) {
            this.lock = lock;
            this.name = name;
            this.mode = mode;
        }

        @Override
        public void lock() {
            log.debug("requesting lock() {} lock on {}", (Object)this.mode, (Object)this.name);
            this.lock.lock();
            log.debug("acquired lock() {} lock on {}", (Object)this.mode, (Object)this.name);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            log.debug("requesting lockInterruptibly() {} lock on {}", (Object)this.mode, (Object)this.name);
            this.lock.lockInterruptibly();
            log.debug("acquired lockInterruptibly() {} lock on {}", (Object)this.mode, (Object)this.name);
        }

        @Override
        public boolean tryLock() {
            boolean locked = this.lock.tryLock();
            log.debug("tryLock() {} lock on {} returned {}", new Object[]{this.mode, this.name, locked});
            return locked;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            boolean locked = this.lock.tryLock(time, unit);
            log.debug("tryLock() {} lock on {} returned {}", new Object[]{this.mode, this.name, locked});
            return locked;
        }

        @Override
        public void unlock() {
            this.lock.unlock();
            log.debug("unlock() {} lock on {}", (Object)this.mode, (Object)this.name);
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

