/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.SearchType;
import org.apache.maven.index.UniqueArtifactFilterPostprocessor;
import org.sonatype.nexus.index.IndexerManager;
import org.sonatype.nexus.index.Searcher;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;

@Named(value="mavenCoordinates")
@Singleton
public class MavenCoordinatesSearcher
implements Searcher {
    public static final String TERM_GROUP = "g";
    public static final String TERM_ARTIFACT = "a";
    public static final String TERM_VERSION = "v";
    public static final String TERM_PACKAGING = "p";
    public static final String TERM_CLASSIFIER = "c";
    private final IndexerManager m_lucene;

    @Inject
    public MavenCoordinatesSearcher(IndexerManager m_lucene) {
        this.m_lucene = m_lucene;
    }

    @Override
    public boolean canHandle(Map<String, String> terms) {
        return terms.containsKey(TERM_GROUP) && !StringUtils.isEmpty((String)terms.get(TERM_GROUP)) || terms.containsKey(TERM_ARTIFACT) && !StringUtils.isEmpty((String)terms.get(TERM_ARTIFACT)) || terms.containsKey(TERM_VERSION) && !StringUtils.isEmpty((String)terms.get(TERM_VERSION)) || terms.containsKey(TERM_PACKAGING) && !StringUtils.isEmpty((String)terms.get(TERM_PACKAGING)) || terms.containsKey(TERM_CLASSIFIER) && !StringUtils.isEmpty((String)terms.get(TERM_CLASSIFIER));
    }

    @Override
    public SearchType getDefaultSearchType() {
        return SearchType.EXACT;
    }

    @Override
    public IteratorSearchResponse flatIteratorSearch(Map<String, String> terms, String repositoryId, Integer from, Integer count, Integer hitLimit, boolean uniqueRGA, SearchType searchType, List<ArtifactInfoFilter> filters) throws NoSuchRepositoryException {
        if (!this.canHandle(terms)) {
            return IteratorSearchResponse.empty(null);
        }
        if (filters != null) {
            for (ArtifactInfoFilter filter : filters) {
                if (!(filter instanceof UniqueArtifactFilterPostprocessor)) continue;
                UniqueArtifactFilterPostprocessor uFilter = (UniqueArtifactFilterPostprocessor)filter;
                if (terms.containsKey(TERM_VERSION)) {
                    uFilter.addField(MAVEN.VERSION);
                }
                if (terms.containsKey(TERM_PACKAGING)) {
                    uFilter.addField(MAVEN.PACKAGING);
                }
                if (terms.containsKey(TERM_CLASSIFIER)) {
                    uFilter.addField(MAVEN.CLASSIFIER);
                }
                uFilter.addField(MAVEN.REPOSITORY_ID);
                break;
            }
        }
        return this.m_lucene.searchArtifactIterator(terms.get(TERM_GROUP), terms.get(TERM_ARTIFACT), terms.get(TERM_VERSION), terms.get(TERM_PACKAGING), terms.get(TERM_CLASSIFIER), repositoryId, from, count, hitLimit, false, searchType, filters);
    }
}

