/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IteratorResultSet;

class LockingIteratorResultSet
implements IteratorResultSet {
    private final IteratorResultSet result;
    private final Lock lock;
    private boolean closed;

    public LockingIteratorResultSet(IteratorResultSet result, Lock lock) {
        this.result = result;
        this.lock = lock;
    }

    public boolean hasNext() {
        return this.result.hasNext();
    }

    public ArtifactInfo next() {
        return (ArtifactInfo)this.result.next();
    }

    public void remove() {
        this.result.remove();
    }

    public Iterator<ArtifactInfo> iterator() {
        return this.result.iterator();
    }

    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.result.close();
            }
            finally {
                this.lock.unlock();
                this.closed = true;
            }
        }
    }

    public int getTotalProcessedArtifactInfoCount() {
        return this.result.getTotalProcessedArtifactInfoCount();
    }
}

