/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.maven.index.artifact.GavCalculator;
import org.apache.maven.index.context.DocumentFilter;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;

class LockingIndexingContext
implements IndexingContext {
    private final IndexingContext context;
    private final Lock lock;
    private boolean closed;
    private static final IndexSearcher EMPTY_SEARCHER = new MemoryIndex().createSearcher();

    public LockingIndexingContext(IndexingContext context, Lock lock) {
        this.context = context;
        this.lock = lock;
    }

    public String getId() {
        return this.context.getId();
    }

    public String getRepositoryId() {
        return this.context.getRepositoryId();
    }

    public File getRepository() {
        return this.context.getRepository();
    }

    public String getRepositoryUrl() {
        return this.context.getRepositoryUrl();
    }

    public String getIndexUpdateUrl() {
        return this.context.getIndexUpdateUrl();
    }

    public boolean isSearchable() {
        return this.context.isSearchable();
    }

    public void setSearchable(boolean searchable) {
        throw new UnsupportedOperationException();
    }

    public Date getTimestamp() {
        return this.context.getTimestamp();
    }

    public void updateTimestamp() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void updateTimestamp(boolean save) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void updateTimestamp(boolean save, Date date) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int getSize() throws IOException {
        this.lock.lock();
        try {
            int n = !this.isClosed() ? this.context.getSize() : 0;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public IndexSearcher acquireIndexSearcher() throws IOException {
        this.lock.lock();
        return !this.isClosed() ? this.context.acquireIndexSearcher() : EMPTY_SEARCHER;
    }

    public void releaseIndexSearcher(IndexSearcher s) throws IOException {
        try {
            if (!this.isClosed()) {
                this.context.releaseIndexSearcher(s);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private synchronized boolean isClosed() {
        if (!this.closed) {
            this.closed = this.context.getIndexDirectory() == null;
        }
        return this.closed;
    }

    public IndexWriter getIndexWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    public List<IndexCreator> getIndexCreators() {
        return this.context.getIndexCreators();
    }

    public Analyzer getAnalyzer() {
        return this.context.getAnalyzer();
    }

    public void commit() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void rollback() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void optimize() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close(boolean deleteFiles) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void purge() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void merge(Directory directory) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void merge(Directory directory, DocumentFilter filter) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void replace(Directory directory) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Directory getIndexDirectory() {
        throw new UnsupportedOperationException();
    }

    public File getIndexDirectoryFile() {
        return this.context.getIndexDirectoryFile();
    }

    public GavCalculator getGavCalculator() {
        return this.context.getGavCalculator();
    }

    public void setAllGroups(Collection<String> groups) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Set<String> getAllGroups() throws IOException {
        this.lock.lock();
        try {
            Set set = !this.isClosed() ? this.context.getAllGroups() : Collections.emptySet();
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setRootGroups(Collection<String> groups) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Set<String> getRootGroups() throws IOException {
        this.lock.lock();
        try {
            Set set = !this.isClosed() ? this.context.getRootGroups() : Collections.emptySet();
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void rebuildGroups() throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isReceivingUpdates() {
        return this.context.isReceivingUpdates();
    }

    public IndexingContext getContext() {
        IndexingContext result = this.context;
        while (result instanceof LockingIndexingContext) {
            result = ((LockingIndexingContext)result).getContext();
        }
        return result;
    }
}

