/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.SearchType;
import org.sonatype.nexus.index.IndexerManager;
import org.sonatype.nexus.index.Searcher;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;

@Named(value="keyword")
@Singleton
public class KeywordSearcher
implements Searcher {
    public static final String TERM_KEYWORD = "q";
    private final IndexerManager m_lucene;

    @Inject
    public KeywordSearcher(IndexerManager m_lucene) {
        this.m_lucene = m_lucene;
    }

    @Override
    public boolean canHandle(Map<String, String> terms) {
        return terms.containsKey(TERM_KEYWORD) && !StringUtils.isEmpty((String)terms.get(TERM_KEYWORD));
    }

    @Override
    public SearchType getDefaultSearchType() {
        return SearchType.SCORED;
    }

    @Override
    public IteratorSearchResponse flatIteratorSearch(Map<String, String> terms, String repositoryId, Integer from, Integer count, Integer hitLimit, boolean uniqueRGA, SearchType searchType, List<ArtifactInfoFilter> filters) throws NoSuchRepositoryException {
        if (!this.canHandle(terms)) {
            return IteratorSearchResponse.empty(null);
        }
        return this.m_lucene.searchArtifactIterator(terms.get(TERM_KEYWORD), repositoryId, from, count, hitLimit, uniqueRGA, searchType, filters);
    }
}

