/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.io.File;
import java.io.IOException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.proxy.wastebasket.AbstractRepositoryFolderCleaner;

@Named(value="indexer-lucene")
@Singleton
public class IndexRepositoryFolderCleaner
extends AbstractRepositoryFolderCleaner {
    public void cleanRepositoryFolders(Repository repository, boolean deleteForever) throws IOException {
        if (repository.getRepositoryKind().isFacetAvailable(ShadowRepository.class)) {
            return;
        }
        File indexContextFolder = new File(this.getApplicationConfiguration().getWorkingDirectory("indexer"), repository.getId() + "-ctx");
        if (indexContextFolder.isDirectory()) {
            this.delete(indexContextFolder, true);
        }
    }
}

