/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.util.concurrent.TimeUnit;

class ForceableReentrantLock {
    private final Object lock = new Object();
    private Thread owner;
    private int count;

    ForceableReentrantLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock() {
        Object object = this.lock;
        synchronized (object) {
            if (this.owner != null && this.owner != Thread.currentThread()) {
                return false;
            }
            this.owner = Thread.currentThread();
            ++this.count;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Object object = this.lock;
        synchronized (object) {
            if (this.owner != Thread.currentThread()) {
                throw new IllegalStateException();
            }
            if (--this.count == 0) {
                this.owner = null;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryForceLock(long time, TimeUnit unit) {
        long start = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            while (this.owner != null && this.owner != Thread.currentThread()) {
                if (this.timeout(start, time, unit)) {
                    return false;
                }
                this.owner.interrupt();
                try {
                    this.lock.wait(1000L);
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            this.owner = Thread.currentThread();
            ++this.count;
            return true;
        }
    }

    private boolean timeout(long start, long duration, TimeUnit unit) {
        return System.currentTimeMillis() - start > unit.toMillis(duration);
    }
}

