/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.maven.index.AndMultiArtifactInfoFilter;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactContextProducer;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.ArtifactInfoPostprocessor;
import org.apache.maven.index.ArtifactScanningListener;
import org.apache.maven.index.Field;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.IteratorResultSet;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.MatchHighlightMode;
import org.apache.maven.index.MatchHighlightRequest;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.Scanner;
import org.apache.maven.index.ScanningRequest;
import org.apache.maven.index.SearchType;
import org.apache.maven.index.artifact.Gav;
import org.apache.maven.index.artifact.VersionUtils;
import org.apache.maven.index.context.ContextMemberProvider;
import org.apache.maven.index.context.DefaultIndexingContext;
import org.apache.maven.index.context.DocumentFilter;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.context.MergedIndexingContext;
import org.apache.maven.index.context.StaticContextMemberProvider;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.packer.IndexPacker;
import org.apache.maven.index.packer.IndexPackingRequest;
import org.apache.maven.index.treeview.IndexTreeView;
import org.apache.maven.index.treeview.TreeNode;
import org.apache.maven.index.treeview.TreeNodeFactory;
import org.apache.maven.index.treeview.TreeViewRequest;
import org.apache.maven.index.updater.FSDirectoryFactory;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdateResult;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.index.util.IndexCreatorSorter;
import org.sonatype.nexus.configuration.application.NexusConfiguration;
import org.sonatype.nexus.index.ForceableReentrantLock;
import org.sonatype.nexus.index.GavUtils;
import org.sonatype.nexus.index.IndexArtifactFilter;
import org.sonatype.nexus.index.IndexerManager;
import org.sonatype.nexus.index.LockingIndexingContext;
import org.sonatype.nexus.index.LockingIteratorResultSet;
import org.sonatype.nexus.index.MultiLock;
import org.sonatype.nexus.index.NamedReadWriteLock;
import org.sonatype.nexus.index.NexusIndexingContext;
import org.sonatype.nexus.index.NexusScanningListener;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.attributes.inspectors.DigestCalculatingInspector;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.FileContentLocator;
import org.sonatype.nexus.proxy.item.RepositoryItemUidLock;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.uid.IsHiddenAttribute;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.RepositoryPolicy;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.LocalStatus;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.proxy.storage.local.fs.DefaultFSLocalRepositoryStorage;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.nexus.util.file.DirSupport;
import org.sonatype.scheduling.TaskInterruptedException;
import org.sonatype.scheduling.TaskUtil;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.common.Throwables2;

@Named
@Singleton
public class DefaultIndexerManager
extends ComponentSupport
implements IndexerManager {
    private static final String ARTIFICIAL_EXCEPTION = "This is an artificial exception that provides caller backtrace.";
    public static final String INDEXER_WORKING_DIRECTORY_KEY = "indexer";
    public static final String CTX_SUFIX = "-ctx";
    public static final String PUBLISHING_PATH_PREFIX = "/.index";
    @Inject
    private NexusIndexer mavenIndexer;
    @Inject
    private IndexUpdater indexUpdater;
    @Inject
    private IndexPacker indexPacker;
    @Inject
    private NexusConfiguration nexusConfiguration;
    @Inject
    private RepositoryRegistry repositoryRegistry;
    @Inject
    @Named(value="maven2")
    private ContentClass maven2;
    @Inject
    private List<IndexCreator> indexCreators;
    @Inject
    private IndexArtifactFilter indexArtifactFilter;
    @Inject
    private ArtifactContextProducer artifactContextProducer;
    @Inject
    private MimeSupport mimeSupport;
    @Inject
    private IndexTreeView indexTreeView;
    @Inject
    private Scanner scanner;
    @Inject
    @Nullable
    @Named(value="${lucene.fsdirectory.type}")
    private String luceneFSDirectoryType;
    @Inject
    @Named(value="${nexus.indexer.locktimeout:-60}")
    private int lockTimeoutSeconds;
    private final Map<String, ReadWriteLock> repositoryLocks = new HashMap<String, ReadWriteLock>();
    private final Map<String, ForceableReentrantLock> reindexLocks = new HashMap<String, ForceableReentrantLock>();
    private final ConcurrentMap<String, Thread> deleteThreads = new ConcurrentHashMap<String, Thread>();
    private File workingDirectory;
    private File tempDirectory;
    private final FSDirectoryFactory luceneDirectoryFactory = new FSDirectoryFactory(){

        public FSDirectory open(File indexDir) throws IOException {
            return DefaultIndexerManager.this.openFSDirectory(indexDir);
        }
    };
    private static final boolean REINDEX_PUBLISHES = true;

    private boolean SUPPORTED(Repository repository) {
        return !repository.getRepositoryKind().isFacetAvailable(ShadowRepository.class) && repository.getRepositoryKind().isFacetAvailable(MavenRepository.class) && repository.getRepositoryContentClass().isCompatible(this.maven2);
    }

    private boolean INDEXABLE(Repository repository) {
        return this.SUPPORTED(repository) && repository.isIndexable();
    }

    private boolean INSERVICE(Repository repository) {
        return LocalStatus.IN_SERVICE.equals((Object)repository.getLocalStatus());
    }

    private boolean REMOTEACCESSALLOWED(Repository repository) {
        ProxyRepository proxyRepository = (ProxyRepository)repository.adaptToFacet(ProxyRepository.class);
        if (proxyRepository != null) {
            return proxyRepository.getProxyMode().shouldProxy();
        }
        return false;
    }

    private boolean ISPROXY(Repository repository) {
        return repository.getRepositoryKind().isFacetAvailable(MavenProxyRepository.class);
    }

    private boolean ISGROUP(Repository repository) {
        return repository.getRepositoryKind().isFacetAvailable(GroupRepository.class);
    }

    private boolean INCLUDEINSEARCH(Repository repository) {
        return this.INSERVICE(repository) && (this.ISGROUP(repository) || this.INDEXABLE(repository));
    }

    @VisibleForTesting
    protected void setIndexUpdater(IndexUpdater indexUpdater) {
        this.indexUpdater = indexUpdater;
    }

    @VisibleForTesting
    protected void setScanner(Scanner scanner) {
        this.scanner = scanner;
    }

    protected File getWorkingDirectory() {
        if (this.workingDirectory == null) {
            this.workingDirectory = this.nexusConfiguration.getWorkingDirectory(INDEXER_WORKING_DIRECTORY_KEY);
        }
        return this.workingDirectory;
    }

    protected File getTempDirectory() {
        if (this.tempDirectory == null) {
            this.tempDirectory = this.nexusConfiguration.getTemporaryDirectory();
        }
        return this.tempDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean deleteFiles) throws IOException {
        this.log.info("Shutting down Nexus IndexerManager");
        for (IndexingContext ctx : this.mavenIndexer.getIndexingContexts().values()) {
            this.mavenIndexer.removeIndexingContext(ctx, false);
        }
        Map<String, ForceableReentrantLock> map = this.repositoryLocks;
        synchronized (map) {
            this.repositoryLocks.clear();
        }
        map = this.reindexLocks;
        synchronized (map) {
            this.reindexLocks.clear();
        }
    }

    @Override
    public void resetConfiguration() {
        this.workingDirectory = null;
        this.tempDirectory = null;
    }

    @Override
    public void addRepositoryIndexContext(String repositoryId) throws IOException, NoSuchRepositoryException {
        Repository repository = this.repositoryRegistry.getRepository(repositoryId);
        this.addRepositoryIndexContext(repository);
    }

    public void addRepositoryIndexContext(final Repository repository) throws IOException, NoSuchRepositoryException {
        if (!this.INDEXABLE(repository)) {
            return;
        }
        if (repository.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
            this.repositoryRegistry.getRepositoryWithFacet(repository.getId(), GroupRepository.class);
        } else {
            this.repositoryRegistry.getRepositoryWithFacet(repository.getId(), Repository.class);
        }
        this.exclusiveSingle(repository, new Runnable(){

            @Override
            public void run(IndexingContext context) throws IOException {
                DefaultIndexerManager.this.addRepositoryIndexContext(repository, context);
            }
        });
    }

    private void addRepositoryIndexContext(Repository repository, IndexingContext oldContext) throws IOException {
        this.log.debug("Adding indexing context for repository {}", (Object)repository.getId());
        if (oldContext != null) {
            this.log.error("Old/stale indexing context {} for repository {}. Operation cancaled.", (Object)oldContext.getId(), (Object)repository.getId());
            return;
        }
        Object ctx = null;
        File indexDirectory = this.getRepositoryIndexDirectory(repository);
        File repoRoot = this.getRepositoryLocalStorageAsFile(repository);
        if (repository.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
            ctx = this.mavenIndexer.addMergedIndexingContext(this.getContextId(repository.getId()), repository.getId(), repoRoot, indexDirectory, repository.isSearchable(), Collections.emptyList());
        } else {
            ctx = new NexusIndexingContext(this.getContextId(repository.getId()), repository.getId(), repoRoot, (Directory)this.openFSDirectory(indexDirectory), null, null, IndexCreatorSorter.sort(this.indexCreators), true, this.ISPROXY(repository));
            this.mavenIndexer.addIndexingContext(ctx);
        }
        ctx.setSearchable(repository.isSearchable());
        this.log.debug("Added indexing context {} for repository {}", (Object)ctx.getId(), (Object)repository.getId());
    }

    private File getRepositoryIndexDirectory(Repository repository) throws IOException {
        File indexDirectory = new File(this.getWorkingDirectory(), this.getContextId(repository.getId()));
        DirSupport.mkdir((Path)indexDirectory.toPath());
        return indexDirectory;
    }

    @Override
    public void removeRepositoryIndexContext(String repositoryId, boolean deleteFiles) throws IOException, NoSuchRepositoryException {
        Repository repository = this.repositoryRegistry.getRepository(repositoryId);
        this.removeRepositoryIndexContext(repository, deleteFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepositoryIndexContext(final Repository repository, final boolean deleteFiles) throws IOException {
        Thread otherThread = this.deleteThreads.putIfAbsent(repository.getId(), Thread.currentThread());
        if (otherThread != null) {
            this.log.debug("Indexing context for repository {} is being deleted by thread {}", (Object)repository.getId(), (Object)otherThread.getName());
            return;
        }
        try {
            final boolean[] removed = new boolean[1];
            ForceableReentrantLock lock = this.getReindexLock(repository);
            if (lock.tryForceLock(this.lockTimeoutSeconds, TimeUnit.SECONDS)) {
                try {
                    this.exclusiveSingle(repository, new Runnable(){

                        @Override
                        public void run(IndexingContext context) throws IOException {
                            DefaultIndexerManager.this.removeRepositoryIndexingContext(repository, deleteFiles, context);
                            removed[0] = true;
                        }
                    });
                }
                finally {
                    lock.unlock();
                }
            }
            if (!removed[0]) {
                throw new IOException("Could not remove indexing context for repository " + repository.getId());
            }
        }
        finally {
            this.deleteThreads.remove(repository.getId());
        }
    }

    private void removeRepositoryIndexingContext(Repository repository, boolean deleteFiles, IndexingContext context) throws IOException {
        if (context != null) {
            this.log.debug("Removing indexing context for repository {} deleteFiles={}", (Object)repository.getId(), (Object)deleteFiles);
            this.mavenIndexer.removeIndexingContext(context, deleteFiles);
            this.log.debug("Removed indexing context {} for repository {}", (Object)context.getId(), (Object)repository.getId());
        } else {
            this.log.debug("Could not remove <null> indexing context for repository {}", (Object)repository.getId());
        }
    }

    @Override
    public void updateRepositoryIndexContext(final String repositoryId) throws IOException, NoSuchRepositoryException {
        final Repository repository = this.repositoryRegistry.getRepository(repositoryId);
        if (!this.SUPPORTED(repository)) {
            return;
        }
        if (repository.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
            this.repositoryRegistry.getRepositoryWithFacet(repositoryId, GroupRepository.class);
        } else {
            this.repositoryRegistry.getRepositoryWithFacet(repositoryId, Repository.class);
        }
        this.exclusiveSingle(repository, new Runnable(){

            @Override
            public void run(IndexingContext context) throws IOException {
                DefaultIndexerManager.this.log.debug("Updating indexing context for repository {}", (Object)repository.getId());
                File repoRoot = DefaultIndexerManager.this.getRepositoryLocalStorageAsFile(repository);
                if (!(context == null || !DefaultIndexerManager.this.ISGROUP(repository) && DefaultIndexerManager.this.INDEXABLE(repository) && context.getRepository().getAbsolutePath().equals(repoRoot.getAbsolutePath()) && context.isSearchable() == repository.isSearchable())) {
                    DefaultIndexerManager.this.removeRepositoryIndexContext(repository, false);
                    context = null;
                }
                if (DefaultIndexerManager.this.INDEXABLE(repository) && context == null) {
                    try {
                        DefaultIndexerManager.this.addRepositoryIndexContext(repository);
                    }
                    catch (NoSuchRepositoryException e) {
                        DefaultIndexerManager.this.log.debug("Could not add indexing context for repository {}", (Object)repositoryId, (Object)e);
                    }
                }
                DefaultIndexerManager.this.log.debug("Updated indexing context for repository {}", (Object)repository.getId());
            }
        });
    }

    public IndexingContext getRepositoryIndexContext(Repository repository) {
        return (IndexingContext)this.mavenIndexer.getIndexingContexts().get(this.getContextId(repository.getId()));
    }

    protected File getRepositoryLocalStorageAsFile(Repository repository) {
        if (repository.getLocalUrl() != null && repository.getLocalStorage() instanceof DefaultFSLocalRepositoryStorage) {
            try {
                File baseDir = ((DefaultFSLocalRepositoryStorage)repository.getLocalStorage()).getBaseDir(repository, new ResourceStoreRequest("/"));
                return baseDir;
            }
            catch (LocalStorageException e) {
                this.log.warn(String.format("Cannot determine \"%s\" (ID=%s) repository's basedir:", repository.getName(), repository.getId()), (Throwable)e);
            }
        }
        return null;
    }

    protected NexusIndexer getNexusIndexer() {
        return this.mavenIndexer;
    }

    @Override
    public void addItemToIndex(final Repository repository, final StorageItem item) throws IOException {
        if (!this.INDEXABLE(repository) || !this.INSERVICE(repository)) {
            return;
        }
        if (item.getRepositoryItemUid().getBooleanAttributeValue(IsHiddenAttribute.class)) {
            return;
        }
        if (item instanceof StorageFileItem && ((StorageFileItem)item).isContentGenerated()) {
            return;
        }
        org.sonatype.nexus.proxy.maven.gav.Gav gav = ((MavenRepository)repository).getGavCalculator().pathToGav(item.getRepositoryItemUid().getPath());
        if (gav == null || gav.isSignature() || gav.isHash()) {
            return;
        }
        this.sharedSingle(repository, new Runnable(){

            @Override
            public void run(IndexingContext context) throws IOException {
                DefaultIndexerManager.this.addItemToIndex(repository, item, context);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addItemToIndex(Repository repository, StorageItem item, IndexingContext context) throws LocalStorageException, IOException {
        RepositoryItemUidLock uidLock = item.getRepositoryItemUid().getLock();
        uidLock.lock(Action.read);
        try {
            File file;
            ArtifactContext ac = null;
            if (DefaultFSLocalRepositoryStorage.class.isAssignableFrom(repository.getLocalStorage().getClass()) && (file = ((DefaultFSLocalRepositoryStorage)repository.getLocalStorage()).getFileFromBase(repository, new ResourceStoreRequest(item))).exists()) {
                try {
                    ac = this.artifactContextProducer.getArtifactContext(context, file);
                }
                catch (IllegalArgumentException e) {
                    uidLock.unlock();
                    return;
                }
                if (ac != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("The ArtifactContext created from file is fine, continuing.");
                    }
                    ArtifactInfo ai = ac.getArtifactInfo();
                    if (ai.sha1 == null) {
                        ai.sha1 = item.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_SHA1_KEY);
                    }
                }
            }
            this.getNexusIndexer().addArtifactToIndex(ac, context);
        }
        finally {
            uidLock.unlock();
        }
    }

    @Override
    public void removeItemFromIndex(final Repository repository, final StorageItem item) throws IOException {
        if (!this.INDEXABLE(repository) || !this.INSERVICE(repository)) {
            return;
        }
        if (this.ISPROXY(repository)) {
            return;
        }
        this.sharedSingle(repository, new Runnable(){

            @Override
            public void run(IndexingContext context) throws IOException {
                DefaultIndexerManager.this.removeItemFromIndex(repository, item, context);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeItemFromIndex(Repository repository, StorageItem item, IndexingContext context) throws IOException {
        org.sonatype.nexus.proxy.maven.gav.Gav gav = null;
        gav = ((MavenRepository)repository).getGavCalculator().pathToGav(item.getRepositoryItemUid().getPath());
        if (gav == null || gav.isSignature() || gav.isHash()) {
            return;
        }
        ArtifactInfo ai = new ArtifactInfo(context.getRepositoryId(), gav.getGroupId(), gav.getArtifactId(), gav.getBaseVersion(), gav.getClassifier());
        if (!Strings.isNullOrEmpty((String)ai.classifier)) {
            ai.packaging = gav.getExtension();
        }
        ArtifactContext ac = null;
        Gav igav = GavUtils.convert(gav);
        try {
            ac = new ArtifactContext(null, null, null, ai, igav);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deleting artifact " + ai.groupId + ":" + ai.artifactId + ":" + ai.version + " from index (DELETE).");
        }
        if (!item.getItemContext().containsKey((Object)"moreTsSnapshotsExistsForGav")) {
            RepositoryItemUidLock uidLock = item.getRepositoryItemUid().getLock();
            uidLock.lock(Action.read);
            try {
                this.getNexusIndexer().deleteArtifactFromIndex(ac, context);
            }
            finally {
                uidLock.unlock();
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("NOT deleting artifact " + ac.getArtifactInfo().groupId + ":" + ac.getArtifactInfo().artifactId + ":" + ac.getArtifactInfo().version + " from index (DELETE), since it is a timestamped snapshot and more builds exists.");
        }
    }

    @Override
    public void reindexAllRepositories(String fromPath, boolean fullReindex) throws IOException {
        this.log.debug("Reindexing all repositories fromPath={} fullReindex={}", (Object)fromPath, (Object)fullReindex);
        List reposes = this.repositoryRegistry.getRepositories();
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (Repository repository : reposes) {
            TaskUtil.checkInterruption();
            try {
                this.reindexRepository(repository, fromPath, fullReindex);
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        for (Repository repository : reposes) {
            TaskUtil.checkInterruption();
            try {
                this.publishRepositoryIndex(repository);
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            throw (IOException)Throwables2.composite((Throwable)new IOException("Exception(s) happened during reindexAllRepositories()"), exceptions);
        }
    }

    @Override
    public void reindexRepository(String path, String repositoryId, boolean fullReindex) throws NoSuchRepositoryException, IOException {
        Repository repository = this.repositoryRegistry.getRepository(repositoryId);
        this.reindexRepository(path, repository, fullReindex, new HashSet<String>());
    }

    protected void reindexRepository(final String path, Repository repository, final boolean fullReindex, final Set<String> processedRepositoryIds) throws IOException {
        if (!processedRepositoryIds.add(repository.getId())) {
            return;
        }
        List<IOException> exceptions = new GroupOperation(repository){

            @Override
            protected void perform(Repository member) throws IOException {
                DefaultIndexerManager.this.reindexRepository(path, member, fullReindex, processedRepositoryIds);
            }
        }.perform();
        TaskUtil.checkInterruption();
        this.reindexRepository(repository, path, fullReindex);
        this.publishRepositoryIndex(repository);
        if (!exceptions.isEmpty()) {
            throw (IOException)Throwables2.composite((Throwable)new IOException("Exception(s) happened during reindexAllRepositories()"), exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void reindexRepository(Repository repository, String fromPath, boolean fullReindex) throws IOException {
        block9: {
            block10: {
                if (!this.INDEXABLE(repository) || !this.INSERVICE(repository)) {
                    return;
                }
                if (this.ISGROUP(repository)) {
                    if (fullReindex) {
                        this.deleteIndexItems(repository);
                    }
                    return;
                }
                reindexLock = this.getReindexLock(repository);
                if (!reindexLock.tryLock()) break block10;
                try {
                    this.log.debug("Reindexing repository {} fromPath={} fullReindex={}", new Object[]{repository.getId(), fromPath, fullReindex});
                    if (fullReindex) ** GOTO lbl20
                    try {
                        runnable = new IndexUpdateRunnable(repository, fromPath, false);
                        this.sharedSingle(repository, runnable);
                        this.log.debug("Reindexed repository {}", (Object)repository.getId());
                        return;
                    }
                    catch (IncrementalIndexUpdateException e) {
                        this.log.info("Unable to incrementally update index for repository {}. Trying full index update", (Object)repository.getId());
lbl20:
                        // 2 sources

                        runnable = new IndexUpdateRunnable(repository, fromPath, true);
                        this.deleteIndexItems(repository);
                        this.temporary(repository, runnable);
                        this.log.debug("Reindexed repository {}", (Object)repository.getId());
                        break block9;
                    }
                }
                finally {
                    reindexLock.unlock();
                }
            }
            this.log.info("Repository '{}' is already in the process of being re-indexed. Skipping additional reindex requests.", (Object)repository.getId());
        }
    }

    @Override
    public void downloadAllIndex() throws IOException {
        this.log.debug("Downloading remote indexes for all repositories");
        List reposes = this.repositoryRegistry.getRepositoriesWithFacet(ProxyRepository.class);
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (ProxyRepository repository : reposes) {
            try {
                this.downloadRepositoryIndex(repository, false);
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            throw (IOException)Throwables2.composite((Throwable)new IOException("Exception(s) happened during downloadAllIndex()"), exceptions);
        }
    }

    @Override
    public void downloadRepositoryIndex(String repositoryId) throws IOException, NoSuchRepositoryException {
        Repository repository = this.repositoryRegistry.getRepository(repositoryId);
        this.downloadRepositoryIndex(repository, new HashSet<String>());
    }

    public void downloadRepositoryIndex(Repository repository, final Set<String> processedRepositoryIds) throws IOException {
        if (!processedRepositoryIds.add(repository.getId())) {
            return;
        }
        List<IOException> exceptions = new GroupOperation(repository){

            @Override
            protected void perform(Repository member) throws IOException {
                DefaultIndexerManager.this.downloadRepositoryIndex(member, processedRepositoryIds);
            }
        }.perform();
        if (this.ISPROXY(repository)) {
            TaskUtil.checkInterruption();
            this.downloadRepositoryIndex((ProxyRepository)repository.adaptToFacet(ProxyRepository.class), false);
        }
        if (!exceptions.isEmpty()) {
            throw (IOException)Throwables2.composite((Throwable)new IOException("Exception(s) happened during reindexAllRepositories()"), exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void downloadRepositoryIndex(final ProxyRepository repository, boolean forceFullUpdate) throws IOException {
        block7: {
            block8: {
                TaskUtil.checkInterruption();
                if (!(this.INDEXABLE((Repository)repository) && this.INSERVICE((Repository)repository) && this.ISPROXY((Repository)repository))) {
                    return;
                }
                reindexLock = this.getReindexLock((Repository)repository);
                if (!reindexLock.tryLock()) break block8;
                try {
                    if (forceFullUpdate) ** GOTO lbl15
                    try {
                        runnable = new Runnable(){

                            @Override
                            public void run(IndexingContext context) throws IOException {
                                DefaultIndexerManager.this.updateRemoteIndex(repository, context, false);
                            }
                        };
                        this.sharedSingle((Repository)repository, runnable);
                        return;
                    }
                    catch (IncrementalIndexUpdateException e) {
                        this.log.info("Unable to incrementally update index for repository {}. Trying full index update", (Object)repository.getId());
lbl15:
                        // 2 sources

                        runnable = new Runnable(){

                            @Override
                            public void run(IndexingContext context) throws IOException {
                                DefaultIndexerManager.this.updateRemoteIndex(repository, context, true);
                            }
                        };
                        this.temporary((Repository)repository, runnable);
                        break block7;
                    }
                }
                finally {
                    reindexLock.unlock();
                }
            }
            this.log.info("Repository '%s' is already in the process of being re-indexed. Skipping additional download index requests.", (Object)repository.getId());
        }
    }

    private void updateRemoteIndex(final ProxyRepository repository, IndexingContext context, boolean forceFullUpdate) throws IOException {
        if (!this.INDEXABLE((Repository)repository) || !this.ISPROXY((Repository)repository)) {
            return;
        }
        if (!((MavenProxyRepository)repository.adaptToFacet(MavenProxyRepository.class)).isDownloadRemoteIndexes()) {
            return;
        }
        this.log.info(RepositoryStringUtils.getFormattedMessage((String)"Trying to get remote index for repository %s", (Repository)repository));
        repository.expireCaches(new ResourceStoreRequest(PUBLISHING_PATH_PREFIX));
        IndexUpdateRequest updateRequest = new IndexUpdateRequest(context, new ResourceFetcher(){

            public void connect(String id, String url) throws IOException {
            }

            public void disconnect() throws IOException {
            }

            public InputStream retrieve(String name) throws IOException {
                TaskUtil.checkInterruption();
                ResourceStoreRequest req = new ResourceStoreRequest("/.index/" + name);
                try {
                    StorageFileItem item = null;
                    if (!DefaultIndexerManager.this.ISPROXY((Repository)repository) || !DefaultIndexerManager.this.REMOTEACCESSALLOWED((Repository)repository)) {
                        throw new ItemNotFoundException(req, (Repository)repository);
                    }
                    item = (StorageFileItem)repository.getRemoteStorage().retrieveItem(repository, req, repository.getRemoteUrl());
                    return item.getInputStream();
                }
                catch (ItemNotFoundException ex) {
                    FileNotFoundException fne = new FileNotFoundException(name + " (remote item not found)");
                    fne.initCause(ex);
                    throw fne;
                }
            }
        });
        if (forceFullUpdate) {
            updateRequest.setForceFullUpdate(true);
            updateRequest.setIncrementalOnly(false);
        } else {
            updateRequest.setForceFullUpdate(false);
            updateRequest.setIncrementalOnly(true);
        }
        updateRequest.setFSDirectoryFactory(this.luceneDirectoryFactory);
        if (repository instanceof MavenRepository) {
            MavenRepository mrepository = (MavenRepository)repository;
            updateRequest.setDocumentFilter(this.getFilterFor(mrepository.getRepositoryPolicy()));
        }
        try {
            boolean hasRemoteIndexUpdate;
            IndexUpdateResult result = this.indexUpdater.fetchAndUpdateIndex(updateRequest);
            if (!result.isSuccessful()) {
                throw new IncrementalIndexUpdateException("Cannot incrementally update index. Request a full update");
            }
            boolean bl = hasRemoteIndexUpdate = result.getTimestamp() != null;
            if (hasRemoteIndexUpdate) {
                this.log.info(RepositoryStringUtils.getFormattedMessage((String)"Remote indexes updated successfully for repository %s", (Repository)repository));
            } else {
                this.log.info(RepositoryStringUtils.getFormattedMessage((String)"Remote indexes unchanged (no update needed) for repository %s", (Repository)repository));
            }
        }
        catch (FileNotFoundException e) {
            if (this.log.isDebugEnabled()) {
                this.log.info(RepositoryStringUtils.getFormattedMessage((String)"Cannot fetch remote index for repository %s as it does not publish indexes.", (Repository)repository), (Throwable)e);
            } else {
                this.log.info(RepositoryStringUtils.getFormattedMessage((String)"Cannot fetch remote index for repository %s as it does not publish indexes.", (Repository)repository));
            }
        }
        catch (TaskInterruptedException e) {
            this.log.warn(RepositoryStringUtils.getFormattedMessage((String)"Cannot fetch remote index for repository %s, task cancelled.", (Repository)repository));
        }
        catch (IncrementalIndexUpdateException e) {
            this.log.info("Cannot incrementally update index for repository {}", (Object)repository.getId());
            throw e;
        }
        catch (IOException e) {
            this.log.warn(RepositoryStringUtils.getFormattedMessage((String)"Cannot fetch remote index for repository %s due to IO problem.", (Repository)repository), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            String message = RepositoryStringUtils.getFormattedMessage((String)"Cannot fetch remote index for repository %s, error occurred.", (Repository)repository);
            this.log.warn(message, (Throwable)e);
            throw new IOException(message, e);
        }
    }

    private DocumentFilter getFilterFor(final RepositoryPolicy repositoryPolicy) {
        return new DocumentFilter(){

            public boolean accept(Document doc) {
                String uinfo = doc.get(ArtifactInfo.UINFO);
                if (uinfo == null) {
                    return true;
                }
                String[] r = ArtifactInfo.FS_PATTERN.split(uinfo);
                if (repositoryPolicy == RepositoryPolicy.SNAPSHOT) {
                    return VersionUtils.isSnapshot((String)r[2]);
                }
                if (repositoryPolicy == RepositoryPolicy.RELEASE) {
                    return !VersionUtils.isSnapshot((String)r[2]);
                }
                return true;
            }
        };
    }

    @Override
    public void publishAllIndex() throws IOException {
        this.log.debug("Publishing indexes for all repositories");
        List reposes = this.repositoryRegistry.getRepositories();
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (Repository repository : reposes) {
            TaskUtil.checkInterruption();
            try {
                this.publishRepositoryIndex(repository);
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            throw (IOException)Throwables2.composite((Throwable)new IOException("Exception(s) happened during publishAllIndex()"), exceptions);
        }
    }

    @Override
    public void publishRepositoryIndex(String repositoryId) throws IOException, NoSuchRepositoryException {
        Repository repository = this.repositoryRegistry.getRepository(repositoryId);
        this.publishRepositoryIndex(repository, new HashSet<String>());
    }

    protected void publishRepositoryIndex(Repository repository, final Set<String> processedRepositoryIds) throws IOException {
        if (!processedRepositoryIds.add(repository.getId())) {
            return;
        }
        List<IOException> exceptions = new GroupOperation(repository){

            @Override
            protected void perform(Repository member) throws IOException {
                DefaultIndexerManager.this.publishRepositoryIndex(member, processedRepositoryIds);
            }
        }.perform();
        TaskUtil.checkInterruption();
        this.publishRepositoryIndex(repository);
        if (!exceptions.isEmpty()) {
            throw (IOException)Throwables2.composite((Throwable)new IOException("Exception(s) happened during reindexAllRepositories()"), exceptions);
        }
    }

    protected void publishRepositoryIndex(final Repository repository) throws IOException {
        if (!this.INDEXABLE(repository) || !this.INSERVICE(repository)) {
            return;
        }
        ForceableReentrantLock reindexLock = this.getReindexLock(repository);
        if (reindexLock.tryLock()) {
            try {
                this.shared(repository, new Runnable(){

                    @Override
                    public void run(IndexingContext context) throws IOException {
                        DefaultIndexerManager.this.publishRepositoryIndex(repository, context);
                    }
                });
            }
            finally {
                reindexLock.unlock();
            }
        } else {
            this.log.info("Repository '{}' is already in the process of being re-indexed. Skipping additional publish index requests.", (Object)repository.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishRepositoryIndex(Repository repository, IndexingContext context) throws IOException {
        this.log.debug("Publishing index for repository {}", (Object)repository.getId());
        File targetDir = null;
        try {
            TaskUtil.checkInterruption();
            this.log.info("Publishing index for repository " + repository.getId());
            targetDir = new File(this.getTempDirectory(), "nx-index-" + Long.toHexString(System.nanoTime()));
            DirSupport.mkdir((Path)targetDir.toPath());
            IndexPackingRequest packReq = new IndexPackingRequest(context, targetDir);
            packReq.setCreateIncrementalChunks(true);
            packReq.setFormats(Arrays.asList(IndexPackingRequest.IndexFormat.FORMAT_V1));
            this.indexPacker.packIndex(packReq);
            File[] files = targetDir.listFiles();
            if (files != null) {
                for (File file : files) {
                    TaskUtil.checkInterruption();
                    this.storeIndexItem(repository, file, context);
                }
            }
            this.log.debug("Published index for repository {}", (Object)repository.getId());
        }
        finally {
            IOException lastException = null;
            if (targetDir != null) {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Cleanup of temp files...");
                    }
                    DirSupport.deleteIfExists((Path)targetDir.toPath());
                }
                catch (IOException e) {
                    lastException = e;
                    this.log.warn("Cleanup of temp files FAILED...", (Throwable)e);
                }
            }
            if (lastException != null) {
                IOException eek = new IOException(lastException);
                throw eek;
            }
        }
    }

    protected void deleteIndexItems(Repository repository) {
        ResourceStoreRequest request = new ResourceStoreRequest(PUBLISHING_PATH_PREFIX);
        try {
            this.shared(repository, new Runnable(){

                @Override
                public void run(IndexingContext context) throws IOException {
                    if (context.getIndexDirectoryFile() != null) {
                        new File(context.getIndexDirectoryFile(), "nexus-maven-repository-index-packer.properties").delete();
                    }
                }
            });
            repository.deleteItem(false, request);
        }
        catch (ItemNotFoundException itemNotFoundException) {
        }
        catch (Exception e) {
            this.log.error("Cannot delete index items!", (Throwable)e);
        }
    }

    protected void storeIndexItem(Repository repository, File file, IndexingContext context) {
        String path = "/.index/" + file.getName();
        try {
            ResourceStoreRequest request = new ResourceStoreRequest(path);
            DefaultStorageFileItem fItem = new DefaultStorageFileItem(repository, request, true, true, (ContentLocator)new FileContentLocator(file, this.mimeSupport.guessMimeTypeFromPath(repository.getMimeRulesSource(), file.getAbsolutePath())));
            if (context.getTimestamp() == null) {
                fItem.setModified(0L);
                fItem.setCreated(0L);
            } else {
                fItem.setModified(context.getTimestamp().getTime());
                fItem.setCreated(context.getTimestamp().getTime());
            }
            if (repository instanceof MavenRepository) {
                ((MavenRepository)repository).storeItemWithChecksums(false, (AbstractStorageItem)fItem);
            } else {
                repository.storeItem(false, (StorageItem)fItem);
            }
        }
        catch (Exception e) {
            this.log.error("Cannot store index file " + path, (Throwable)e);
        }
    }

    @Override
    public void optimizeAllRepositoriesIndex() throws IOException {
        this.log.debug("Optimizing indexes for all repositories");
        List repos = this.repositoryRegistry.getRepositories();
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (Repository repository : repos) {
            TaskUtil.checkInterruption();
            try {
                this.optimizeRepositoryIndex(repository);
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            throw (IOException)Throwables2.composite((Throwable)new IOException("Exception(s) happened during optimizeAllRepositoriesIndex()"), exceptions);
        }
    }

    @Override
    public void optimizeRepositoryIndex(String repositoryId) throws NoSuchRepositoryException, IOException {
        Repository repository = this.repositoryRegistry.getRepository(repositoryId);
        this.optimizeIndex(repository, new HashSet<String>());
    }

    protected void optimizeIndex(Repository repository, final Set<String> processedRepositoryIds) throws CorruptIndexException, IOException {
        if (!processedRepositoryIds.add(repository.getId())) {
            return;
        }
        List<IOException> exceptions = new GroupOperation(repository){

            @Override
            protected void perform(Repository member) throws IOException {
                DefaultIndexerManager.this.optimizeIndex(member, processedRepositoryIds);
            }
        }.perform();
        TaskUtil.checkInterruption();
        this.optimizeRepositoryIndex(repository);
        if (!exceptions.isEmpty()) {
            throw (IOException)Throwables2.composite((Throwable)new IOException("Exception(s) happened during reindexAllRepositories()"), exceptions);
        }
    }

    protected void optimizeRepositoryIndex(final Repository repository) throws CorruptIndexException, IOException {
        if (!this.INDEXABLE(repository)) {
            return;
        }
        this.sharedSingle(repository, new Runnable(){

            @Override
            public void run(IndexingContext context) throws IOException {
                TaskUtil.checkInterruption();
                DefaultIndexerManager.this.log.debug("Optimizing index for repository {} ", (Object)repository.getId());
                context.optimize();
                DefaultIndexerManager.this.log.debug("Optimized index for repository {} ", (Object)repository.getId());
            }
        });
    }

    @Override
    public Collection<ArtifactInfo> identifyArtifact(Field field, String data) throws IOException {
        return this.mavenIndexer.identify(field, data);
    }

    @Override
    @Deprecated
    public FlatSearchResponse searchArtifactFlat(String term, String repositoryId, Integer from, Integer count, Integer hitLimit) throws NoSuchRepositoryException {
        Query q1 = this.mavenIndexer.constructQuery(MAVEN.GROUP_ID, term, SearchType.SCORED);
        Query q2 = this.mavenIndexer.constructQuery(MAVEN.ARTIFACT_ID, term, SearchType.SCORED);
        BooleanQuery bq = new BooleanQuery();
        bq.add(q1, BooleanClause.Occur.SHOULD);
        bq.add(q2, BooleanClause.Occur.SHOULD);
        FlatSearchRequest req = new FlatSearchRequest((Query)bq, ArtifactInfo.REPOSITORY_VERSION_COMPARATOR);
        if (hitLimit != null) {
            req.setCount(hitLimit.intValue());
        }
        if (count != null) {
            req.setCount(count.intValue());
        }
        return this.searchFlat(repositoryId, req);
    }

    @Override
    @Deprecated
    public FlatSearchResponse searchArtifactClassFlat(String term, String repositoryId, Integer from, Integer count, Integer hitLimit) throws NoSuchRepositoryException {
        if (term.endsWith(".class")) {
            term = term.substring(0, term.length() - 6);
        }
        Query q = this.mavenIndexer.constructQuery(MAVEN.CLASSNAMES, term, SearchType.SCORED);
        FlatSearchRequest req = new FlatSearchRequest(q, ArtifactInfo.REPOSITORY_VERSION_COMPARATOR);
        if (hitLimit != null) {
            req.setCount(hitLimit.intValue());
        }
        if (count != null) {
            req.setCount(count.intValue());
        }
        return this.searchFlat(repositoryId, req);
    }

    @Override
    @Deprecated
    public FlatSearchResponse searchArtifactFlat(String gTerm, String aTerm, String vTerm, String pTerm, String cTerm, String repositoryId, Integer from, Integer count, Integer hitLimit) throws NoSuchRepositoryException {
        if (gTerm == null && aTerm == null && vTerm == null) {
            return new FlatSearchResponse(null, -1, new HashSet());
        }
        BooleanQuery bq = new BooleanQuery();
        if (gTerm != null) {
            bq.add(this.constructQuery(MAVEN.GROUP_ID, gTerm, SearchType.SCORED), BooleanClause.Occur.MUST);
        }
        if (aTerm != null) {
            bq.add(this.constructQuery(MAVEN.ARTIFACT_ID, aTerm, SearchType.SCORED), BooleanClause.Occur.MUST);
        }
        if (vTerm != null) {
            bq.add(this.constructQuery(MAVEN.VERSION, vTerm, SearchType.SCORED), BooleanClause.Occur.MUST);
        }
        if (pTerm != null) {
            bq.add(this.constructQuery(MAVEN.PACKAGING, pTerm, SearchType.SCORED), BooleanClause.Occur.MUST);
        }
        if (cTerm != null) {
            bq.add(this.constructQuery(MAVEN.CLASSIFIER, cTerm, SearchType.SCORED), BooleanClause.Occur.MUST);
        }
        FlatSearchRequest req = new FlatSearchRequest((Query)bq, ArtifactInfo.REPOSITORY_VERSION_COMPARATOR);
        if (hitLimit != null) {
            req.setCount(hitLimit.intValue());
        }
        if (count != null) {
            req.setCount(count.intValue());
        }
        return this.searchFlat(repositoryId, req);
    }

    @Deprecated
    protected void postprocessResults(Collection<ArtifactInfo> res) {
        Iterator<ArtifactInfo> i = res.iterator();
        while (i.hasNext()) {
            ArtifactInfo ai = i.next();
            if (this.indexArtifactFilter.filterArtifactInfo(ai)) {
                ai.context = this.formatContextId(ai);
                continue;
            }
            i.remove();
        }
    }

    @Deprecated
    protected String formatContextId(ArtifactInfo ai) {
        String result = ai.context;
        try {
            Repository sourceRepository = this.repositoryRegistry.getRepository(ai.repository);
            result = sourceRepository.getName();
        }
        catch (NoSuchRepositoryException noSuchRepositoryException) {
            // empty catch block
        }
        return result;
    }

    protected IteratorSearchRequest createRequest(Query bq, Integer from, Integer count, Integer hitLimit, boolean uniqueRGA, List<ArtifactInfoFilter> extraFilters) {
        IteratorSearchRequest req = new IteratorSearchRequest(bq);
        ArrayList<ArtifactInfoFilter> filters = new ArrayList<ArtifactInfoFilter>();
        filters.add(new ArtifactInfoFilter(){

            public boolean accepts(IndexingContext ctx, ArtifactInfo ai) {
                return DefaultIndexerManager.this.indexArtifactFilter.filterArtifactInfo(ai);
            }
        });
        if (extraFilters != null && extraFilters.size() > 0) {
            filters.addAll(extraFilters);
        }
        req.setArtifactInfoFilter((ArtifactInfoFilter)new AndMultiArtifactInfoFilter(filters));
        if (uniqueRGA) {
            req.setArtifactInfoPostprocessor(new ArtifactInfoPostprocessor(){

                public void postprocess(IndexingContext ctx, ArtifactInfo ai) {
                    ai.context = "Aggregated";
                    ai.repository = null;
                }
            });
        } else {
            req.setArtifactInfoPostprocessor(new ArtifactInfoPostprocessor(){

                public void postprocess(IndexingContext ctx, ArtifactInfo ai) {
                    String result = ai.context;
                    try {
                        Repository sourceRepository = DefaultIndexerManager.this.repositoryRegistry.getRepository(ai.repository);
                        result = sourceRepository.getName();
                    }
                    catch (NoSuchRepositoryException noSuchRepositoryException) {
                        // empty catch block
                    }
                    ai.context = result;
                }
            });
        }
        if (from != null) {
            req.setStart(from.intValue());
        }
        if (hitLimit != null) {
            req.setCount(hitLimit.intValue());
        }
        if (count != null) {
            req.setCount(count.intValue());
        }
        return req;
    }

    @Override
    public IteratorSearchResponse searchQueryIterator(Query query, String repositoryId, Integer from, Integer count, Integer hitLimit, boolean uniqueRGA, List<ArtifactInfoFilter> filters) throws NoSuchRepositoryException {
        IteratorSearchRequest req = this.createRequest(query, from, count, hitLimit, uniqueRGA, filters);
        return this.searchIterator(repositoryId, req);
    }

    @Override
    public IteratorSearchResponse searchArtifactIterator(String term, String repositoryId, Integer from, Integer count, Integer hitLimit, boolean uniqueRGA, SearchType searchType, List<ArtifactInfoFilter> filters) throws NoSuchRepositoryException {
        Query q1 = this.constructQuery(MAVEN.GROUP_ID, term, searchType);
        q1.setBoost(2.0f);
        Query q2 = this.constructQuery(MAVEN.ARTIFACT_ID, term, searchType);
        q2.setBoost(2.0f);
        BooleanQuery bq = new BooleanQuery();
        bq.add(q1, BooleanClause.Occur.SHOULD);
        bq.add(q2, BooleanClause.Occur.SHOULD);
        IteratorSearchRequest req = this.createRequest((Query)bq, from, count, hitLimit, uniqueRGA, filters);
        req.getMatchHighlightRequests().add(new MatchHighlightRequest(MAVEN.GROUP_ID, q1, MatchHighlightMode.HTML));
        req.getMatchHighlightRequests().add(new MatchHighlightRequest(MAVEN.ARTIFACT_ID, q2, MatchHighlightMode.HTML));
        return this.searchIterator(repositoryId, req);
    }

    @Override
    public IteratorSearchResponse searchArtifactClassIterator(String term, String repositoryId, Integer from, Integer count, Integer hitLimit, SearchType searchType, List<ArtifactInfoFilter> filters) throws NoSuchRepositoryException {
        if (term.endsWith(".class")) {
            term = term.substring(0, term.length() - 6);
        }
        Query q = this.constructQuery(MAVEN.CLASSNAMES, term, searchType);
        IteratorSearchRequest req = this.createRequest(q, from, count, hitLimit, false, filters);
        req.getMatchHighlightRequests().add(new MatchHighlightRequest(MAVEN.CLASSNAMES, q, MatchHighlightMode.HTML));
        return this.searchIterator(repositoryId, req);
    }

    @Override
    public IteratorSearchResponse searchArtifactIterator(String gTerm, String aTerm, String vTerm, String pTerm, String cTerm, String repositoryId, Integer from, Integer count, Integer hitLimit, boolean uniqueRGA, SearchType searchType, List<ArtifactInfoFilter> filters) throws NoSuchRepositoryException {
        if (gTerm == null && aTerm == null && vTerm == null) {
            return IteratorSearchResponse.TOO_MANY_HITS_ITERATOR_SEARCH_RESPONSE;
        }
        BooleanQuery bq = new BooleanQuery();
        if (gTerm != null) {
            bq.add(this.constructQuery(MAVEN.GROUP_ID, gTerm, searchType), BooleanClause.Occur.MUST);
        }
        if (aTerm != null) {
            bq.add(this.constructQuery(MAVEN.ARTIFACT_ID, aTerm, searchType), BooleanClause.Occur.MUST);
        }
        if (vTerm != null) {
            bq.add(this.constructQuery(MAVEN.VERSION, vTerm, searchType), BooleanClause.Occur.MUST);
        }
        if (pTerm != null) {
            bq.add(this.constructQuery(MAVEN.PACKAGING, pTerm, searchType), BooleanClause.Occur.MUST);
        }
        if (cTerm != null) {
            if ("N/P".equalsIgnoreCase(cTerm)) {
                filters.add(0, new ArtifactInfoFilter(){

                    public boolean accepts(IndexingContext ctx, ArtifactInfo ai) {
                        return Strings.isNullOrEmpty((String)ai.classifier);
                    }
                });
            } else {
                bq.add(this.constructQuery(MAVEN.CLASSIFIER, cTerm, searchType), BooleanClause.Occur.MUST);
            }
        }
        IteratorSearchRequest req = this.createRequest((Query)bq, from, count, hitLimit, uniqueRGA, filters);
        return this.searchIterator(repositoryId, req);
    }

    @Override
    public IteratorSearchResponse searchArtifactSha1ChecksumIterator(String sha1Checksum, String repositoryId, Integer from, Integer count, Integer hitLimit, List<ArtifactInfoFilter> filters) throws NoSuchRepositoryException {
        if (sha1Checksum == null || sha1Checksum.length() > 40) {
            return IteratorSearchResponse.TOO_MANY_HITS_ITERATOR_SEARCH_RESPONSE;
        }
        SearchType searchType = sha1Checksum.length() == 40 ? SearchType.EXACT : SearchType.SCORED;
        BooleanQuery bq = new BooleanQuery();
        if (sha1Checksum != null) {
            bq.add(this.constructQuery(MAVEN.SHA1, sha1Checksum, searchType), BooleanClause.Occur.MUST);
        }
        IteratorSearchRequest req = this.createRequest((Query)bq, from, count, hitLimit, false, filters);
        return this.searchIterator(repositoryId, req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlatSearchResponse searchFlat(String repositoryId, FlatSearchRequest req) throws NoSuchRepositoryException {
        LockedIndexingContexts lockedContexts = this.lockSearchTargetIndexingContexts(repositoryId);
        if (lockedContexts == null) {
            return new FlatSearchResponse(req.getQuery(), 0, Collections.emptySet());
        }
        try {
            req.getContexts().addAll(lockedContexts.contexts.values());
            FlatSearchResponse result = this.mavenIndexer.searchFlat(req);
            this.postprocessResults(result.getResults());
            FlatSearchResponse flatSearchResponse = result;
            return flatSearchResponse;
        }
        catch (BooleanQuery.TooManyClauses e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Too many clauses exception caught:", (Throwable)e);
            }
            FlatSearchResponse flatSearchResponse = new FlatSearchResponse(req.getQuery(), -1, new HashSet());
            return flatSearchResponse;
        }
        catch (IOException e) {
            this.log.error("Got I/O exception while searching for query \"" + req.getQuery() + "\"", (Throwable)e);
            FlatSearchResponse flatSearchResponse = new FlatSearchResponse(req.getQuery(), 0, new HashSet());
            return flatSearchResponse;
        }
        finally {
            lockedContexts.lock.unlock();
        }
    }

    private IteratorSearchResponse searchIterator(String repositoryId, IteratorSearchRequest req) throws NoSuchRepositoryException {
        LockedIndexingContexts lockedContexts = this.lockSearchTargetIndexingContexts(repositoryId);
        if (lockedContexts == null) {
            return IteratorSearchResponse.empty((Query)req.getQuery());
        }
        try {
            req.getContexts().addAll(lockedContexts.contexts.values());
            IteratorSearchResponse result = this.mavenIndexer.searchIterator(req);
            Query query = result.getQuery();
            int totalHints = result.getTotalHitsCount();
            LockingIteratorResultSet results = new LockingIteratorResultSet(result.getResults(), lockedContexts.lock);
            return new IteratorSearchResponse(query, totalHints, (IteratorResultSet)results);
        }
        catch (BooleanQuery.TooManyClauses e) {
            lockedContexts.lock.unlock();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Too many clauses exception caught:", (Throwable)e);
            }
            return IteratorSearchResponse.TOO_MANY_HITS_ITERATOR_SEARCH_RESPONSE;
        }
        catch (IOException e) {
            lockedContexts.lock.unlock();
            this.log.error("Got I/O exception while searching for query \"" + req.getQuery().toString() + "\"", (Throwable)e);
            return IteratorSearchResponse.empty((Query)req.getQuery());
        }
        catch (RuntimeException e) {
            lockedContexts.lock.unlock();
            throw e;
        }
    }

    @Override
    @Deprecated
    public Query constructQuery(Field field, String query, SearchType type) throws IllegalArgumentException {
        return this.mavenIndexer.constructQuery(field, query, type);
    }

    @Override
    public Query constructQuery(Field field, SearchExpression expression) throws IllegalArgumentException {
        return this.mavenIndexer.constructQuery(field, expression);
    }

    @Override
    public TreeNode listNodes(TreeNodeFactory factory, String path, String repositoryId) throws NoSuchRepositoryException, IOException {
        return this.listNodes(factory, path, null, null, repositoryId);
    }

    @Override
    public TreeNode listNodes(final TreeNodeFactory factory, final String path, final Map<Field, String> hints, final ArtifactInfoFilter artifactInfoFilter, String repositoryId) throws NoSuchRepositoryException, IOException {
        Repository repository = this.repositoryRegistry.getRepository(repositoryId);
        if (!this.INDEXABLE(repository) || !this.INSERVICE(repository)) {
            return null;
        }
        final TreeNode[] result = new TreeNode[1];
        this.shared(repository, new Runnable(){

            @Override
            public void run(IndexingContext context) throws IOException {
                TreeViewRequest request = new TreeViewRequest(factory, path, hints, artifactInfoFilter, context);
                result[0] = DefaultIndexerManager.this.indexTreeView.listNodes(request);
            }
        });
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shared(Repository repository, Runnable runnable) throws IOException {
        Lock lock = null;
        LockingIndexingContext lockedContext = null;
        if (!this.INCLUDEINSEARCH(repository)) {
            return;
        }
        if (this.ISGROUP(repository)) {
            HashMap<String, Repository> members = new HashMap<String, Repository>();
            this.addGroupMembers(members, (GroupRepository)repository);
            members.put(repository.getId(), repository);
            LockedIndexingContexts lockedContexts = this.lockIndexingContexts(members.values(), repository.getId());
            if (lockedContexts != null) {
                IndexingContext groupContext = lockedContexts.contexts.get(repository.getId());
                ArrayList<IndexingContext> memberContexts = new ArrayList<IndexingContext>();
                for (IndexingContext context : lockedContexts.contexts.values()) {
                    if (context == null || repository.getId().equals(context.getRepositoryId())) continue;
                    memberContexts.add(context);
                }
                lock = lockedContexts.lock;
                if (groupContext instanceof LockingIndexingContext) {
                    groupContext = ((LockingIndexingContext)groupContext).getContext();
                }
                lockedContext = new MergedIndexingContext(groupContext.getId(), groupContext.getRepositoryId(), groupContext.getRepository(), groupContext.getIndexDirectory(), groupContext.isSearchable(), (ContextMemberProvider)new StaticContextMemberProvider(memberContexts)){

                    public Directory getIndexDirectory() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        } else {
            lock = this.getRepositoryLock(repository, false);
            if (lock != null) {
                IndexingContext context = this.getRepositoryIndexContext(repository);
                if (context != null) {
                    lockedContext = new LockingIndexingContext(context, lock);
                } else {
                    lock.unlock();
                    lock = null;
                }
            }
        }
        if (lockedContext != null && lock != null) {
            try {
                runnable.run(lockedContext);
            }
            finally {
                lock.unlock();
            }
        } else {
            this.log.warn("Could not perform index operation on repository {}", (Object)repository.getId(), (Object)new Exception(ARTIFICIAL_EXCEPTION));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sharedSingle(Repository repository, Runnable runnable) throws IOException {
        Lock lock = this.getRepositoryLock(repository, false);
        if (lock != null) {
            try {
                IndexingContext ctx = this.getRepositoryIndexContext(repository);
                if (ctx != null) {
                    runnable.run(ctx);
                } else {
                    this.log.warn("Could not perform index operation on repository {}", (Object)repository.getId(), (Object)new Exception(ARTIFICIAL_EXCEPTION));
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void temporary(final Repository repository, Runnable runnable) throws IOException {
        String indexId = repository.getId() + "-tmp-ctx";
        File location = File.createTempFile(indexId, null, this.getTempDirectory());
        DirSupport.delete((Path)location.toPath());
        DirSupport.mkdir((Path)location.toPath());
        final DefaultIndexingContext temporary = new DefaultIndexingContext(indexId, repository.getId(), this.getRepositoryLocalStorageAsFile(repository), (Directory)this.openFSDirectory(location), null, null, this.indexCreators, true);
        this.log.debug("Created temporary indexing context " + location + " for repository " + repository.getId());
        try {
            runnable.run((IndexingContext)temporary);
            temporary.updateTimestamp(true);
            this.exclusiveSingle(repository, new Runnable(){

                @Override
                public void run(IndexingContext target) throws IOException {
                    if (target != null) {
                        target.replace(temporary.getIndexDirectory());
                    } else {
                        DefaultIndexerManager.this.log.warn("Could not perform index operation on repository {}", (Object)repository.getId(), (Object)new Exception());
                    }
                }
            });
        }
        finally {
            temporary.close(false);
            DirSupport.deleteIfExists((Path)location.toPath());
        }
    }

    private FSDirectory openFSDirectory(File location) throws IOException {
        if (this.luceneFSDirectoryType == null) {
            return new NIOFSDirectory(location);
        }
        if ("mmap".equals(this.luceneFSDirectoryType)) {
            return new MMapDirectory(location);
        }
        if ("nio".equals(this.luceneFSDirectoryType)) {
            return new NIOFSDirectory(location);
        }
        if ("simple".equals(this.luceneFSDirectoryType)) {
            return new SimpleFSDirectory(location);
        }
        throw new IllegalArgumentException("''" + this.luceneFSDirectoryType + "'' is not valid/supported Lucene FSDirectory type. Only ''mmap'', ''nio'' and ''simple'' are allowed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exclusiveSingle(Repository repository, Runnable runnable) throws IOException {
        Lock lock = this.getRepositoryLock(repository, true);
        if (lock != null) {
            try {
                IndexingContext ctx = this.getRepositoryIndexContext(repository);
                runnable.run(ctx);
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lock getRepositoryLock(Repository repository, boolean exclusive) {
        ReadWriteLock rwlock;
        String lockName = exclusive ? "exclusive" : "shared";
        Thread deleteThread = (Thread)this.deleteThreads.get(repository.getId());
        if (deleteThread != null && deleteThread != Thread.currentThread()) {
            this.log.debug("Could not acquire {} lock on repository {}. The repository is being deleted by thread {}.", new Object[]{lockName, repository.getId(), deleteThread.getName()});
            return null;
        }
        Map<String, ReadWriteLock> map = this.repositoryLocks;
        synchronized (map) {
            rwlock = this.repositoryLocks.get(repository.getId());
            if (rwlock == null) {
                rwlock = NamedReadWriteLock.decorate(new ReentrantReadWriteLock(), repository.getId());
                this.repositoryLocks.put(repository.getId(), rwlock);
            }
        }
        try {
            Lock lock;
            Lock lock2 = lock = exclusive ? rwlock.writeLock() : rwlock.readLock();
            if (lock.tryLock(this.lockTimeoutSeconds, TimeUnit.SECONDS)) {
                return lock;
            }
            if (this.log.isDebugEnabled()) {
                this.log.warn("Could not acquire {} lock on repository {} in {} seconds. Consider increasing value of ''nexus.indexer.locktimeout'' parameter. The operation has been aborted.", new Object[]{lockName, repository.getId(), this.lockTimeoutSeconds, new Exception(ARTIFICIAL_EXCEPTION)});
            } else {
                this.log.warn("Could not acquire {} lock on repository {} in {} seconds. Consider increasing value of ''nexus.indexer.locktimeout'' parameter. Enable debug log to recieve more information.", new Object[]{lockName, repository.getId(), this.lockTimeoutSeconds});
            }
        }
        catch (InterruptedException e) {
            this.log.debug("Interrupted {} lock request on repository {}", new Object[]{lockName, repository.getId(), new Exception(ARTIFICIAL_EXCEPTION)});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ForceableReentrantLock getReindexLock(Repository repository) {
        Map<String, ForceableReentrantLock> map = this.reindexLocks;
        synchronized (map) {
            ForceableReentrantLock lock = this.reindexLocks.get(repository.getId());
            if (lock == null) {
                lock = new ForceableReentrantLock();
                this.reindexLocks.put(repository.getId(), lock);
            }
            return lock;
        }
    }

    private LockedIndexingContexts lockSearchTargetIndexingContexts(String repositoryId) throws NoSuchRepositoryException {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        if (repositoryId != null) {
            Repository repository = this.repositoryRegistry.getRepository(repositoryId);
            if (this.INCLUDEINSEARCH(repository)) {
                if (this.ISGROUP(repository)) {
                    HashMap<String, Repository> members = new HashMap<String, Repository>();
                    this.addGroupMembers(members, (GroupRepository)repository);
                    repositories.addAll(members.values());
                } else {
                    repositories.add(repository);
                }
            }
        } else {
            for (Repository repository : this.repositoryRegistry.getRepositories()) {
                if (this.ISGROUP(repository) || !this.INCLUDEINSEARCH(repository) || !repository.isSearchable()) continue;
                repositories.add(repository);
            }
        }
        return this.lockIndexingContexts(repositories, null);
    }

    private LockedIndexingContexts lockIndexingContexts(Collection<Repository> repositories, String force) {
        ArrayList<Repository> sorted = new ArrayList<Repository>(repositories);
        if (sorted.size() > 1) {
            Collections.sort(sorted, new Comparator<Repository>(){

                @Override
                public int compare(Repository o1, Repository o2) {
                    return o1.getId().compareTo(o2.getId());
                }
            });
        }
        ArrayList<Lock> locks = new ArrayList<Lock>();
        LinkedHashMap<String, IndexingContext> contexts = new LinkedHashMap<String, IndexingContext>();
        for (Repository repository : sorted) {
            Lock lock = this.getRepositoryLock(repository, false);
            if (lock == null) continue;
            IndexingContext context = this.getRepositoryIndexContext(repository);
            if (!repository.getId().equals(force) && context == null) {
                lock.unlock();
                continue;
            }
            locks.add(lock);
            contexts.put(repository.getId(), new LockingIndexingContext(context, lock));
        }
        if (contexts.isEmpty()) {
            return null;
        }
        return new LockedIndexingContexts(contexts, new MultiLock(locks));
    }

    private Map<String, Repository> addGroupMembers(Map<String, Repository> repositories, GroupRepository group) {
        for (Repository member : group.getMemberRepositories()) {
            if (!this.INCLUDEINSEARCH(member) || repositories.containsKey(member.getId())) continue;
            if (this.ISGROUP(member)) {
                this.addGroupMembers(repositories, (GroupRepository)member);
                continue;
            }
            repositories.put(member.getId(), member);
        }
        return repositories;
    }

    protected String getContextId(String repoId) {
        return repoId + CTX_SUFIX;
    }

    public IndexingContext getRepositoryIndexContext(String repositoryId) {
        return (IndexingContext)this.mavenIndexer.getIndexingContexts().get(this.getContextId(repositoryId));
    }

    private static class IncrementalIndexUpdateException
    extends IOException {
        private static final long serialVersionUID = 6444842181110866037L;

        public IncrementalIndexUpdateException(String message) {
            super(message);
        }
    }

    private static class LockedIndexingContexts {
        final Map<String, IndexingContext> contexts;
        final Lock lock;

        public LockedIndexingContexts(Map<String, IndexingContext> contexts, Lock lock) {
            this.contexts = contexts;
            this.lock = lock;
        }
    }

    public static interface Runnable {
        public void run(IndexingContext var1) throws IOException;
    }

    private class IndexUpdateRunnable
    implements Runnable {
        Repository repository;
        String fromPath;
        boolean fullReindex;

        IndexUpdateRunnable(Repository repository, String fromPath, boolean fullReindex) {
            this.repository = repository;
            this.fromPath = fromPath;
            this.fullReindex = fullReindex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(IndexingContext context) throws IOException {
            if (DefaultIndexerManager.this.ISPROXY(this.repository)) {
                DefaultIndexerManager.this.updateRemoteIndex((ProxyRepository)this.repository.adaptToFacet(ProxyRepository.class), context, this.fullReindex);
            }
            TaskUtil.checkInterruption();
            IndexSearcher contextIndexSearcher = context.acquireIndexSearcher();
            try {
                NexusScanningListener scanListener = new NexusScanningListener(context, contextIndexSearcher, this.fullReindex, DefaultIndexerManager.this.ISPROXY(this.repository));
                DefaultIndexerManager.this.scanner.scan(new ScanningRequest(context, (ArtifactScanningListener)scanListener, this.fromPath));
            }
            finally {
                context.releaseIndexSearcher(contextIndexSearcher);
            }
        }
    }

    private abstract class GroupOperation {
        private final Repository repository;

        public GroupOperation(Repository repository) {
            this.repository = repository;
        }

        public List<IOException> perform() {
            ArrayList<IOException> exceptions = new ArrayList<IOException>();
            if (DefaultIndexerManager.this.ISGROUP(this.repository)) {
                List members = ((GroupRepository)this.repository.adaptToFacet(GroupRepository.class)).getMemberRepositories();
                for (Repository member : members) {
                    TaskUtil.checkInterruption();
                    try {
                        this.perform(member);
                    }
                    catch (IOException e) {
                        exceptions.add(e);
                    }
                }
            }
            return exceptions;
        }

        protected abstract void perform(Repository var1) throws IOException;
    }
}

