/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.index.ArtifactInfo;
import org.sonatype.nexus.index.IndexArtifactFilter;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.access.NexusItemAuthorizer;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultIndexArtifactFilter
extends ComponentSupport
implements IndexArtifactFilter {
    private final RepositoryRegistry repositoryRegistry;
    private final NexusItemAuthorizer nexusItemAuthorizer;

    @Inject
    public DefaultIndexArtifactFilter(RepositoryRegistry repositoryRegistry, NexusItemAuthorizer nexusItemAuthorizer) {
        this.repositoryRegistry = repositoryRegistry;
        this.nexusItemAuthorizer = nexusItemAuthorizer;
    }

    @Override
    public Collection<ArtifactInfo> filterArtifactInfos(Collection<ArtifactInfo> artifactInfos) {
        if (artifactInfos == null) {
            return null;
        }
        ArrayList<ArtifactInfo> result = new ArrayList<ArtifactInfo>(artifactInfos.size());
        for (ArtifactInfo artifactInfo : artifactInfos) {
            if (!this.filterArtifactInfo(artifactInfo)) continue;
            result.add(artifactInfo);
        }
        return result;
    }

    @Override
    public boolean filterArtifactInfo(ArtifactInfo artifactInfo) {
        try {
            Repository repository = this.repositoryRegistry.getRepository(artifactInfo.repository);
            if (MavenRepository.class.isAssignableFrom(repository.getClass())) {
                MavenRepository mr = (MavenRepository)repository;
                Gav gav = new Gav(artifactInfo.groupId, artifactInfo.artifactId, artifactInfo.version, artifactInfo.classifier, mr.getArtifactPackagingMapper().getExtensionForPackaging(artifactInfo.packaging), null, null, null, false, null, false, null);
                ResourceStoreRequest req = new ResourceStoreRequest(mr.getGavCalculator().gavToPath(gav));
                return this.nexusItemAuthorizer.authorizePath((Repository)mr, req, Action.read);
            }
            return true;
        }
        catch (NoSuchRepositoryException e) {
            this.log.warn("Repository not found for artifact: " + artifactInfo.groupId + ":" + artifactInfo.artifactId + ":" + artifactInfo.version + " in repository: " + artifactInfo.repository, (Throwable)e);
            return false;
        }
    }
}

