/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.SearchType;
import org.sonatype.nexus.index.IndexerManager;
import org.sonatype.nexus.index.Searcher;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;

@Named(value="classname")
@Singleton
public class ClassnameSearcher
implements Searcher {
    public static final String TERM_CLASSNAME = "cn";
    private final IndexerManager m_lucene;

    @Inject
    public ClassnameSearcher(IndexerManager m_lucene) {
        this.m_lucene = m_lucene;
    }

    @Override
    public boolean canHandle(Map<String, String> terms) {
        return terms.containsKey(TERM_CLASSNAME) && !StringUtils.isEmpty((String)terms.get(TERM_CLASSNAME));
    }

    @Override
    public SearchType getDefaultSearchType() {
        return SearchType.SCORED;
    }

    @Override
    public IteratorSearchResponse flatIteratorSearch(Map<String, String> terms, String repositoryId, Integer from, Integer count, Integer hitLimit, boolean uniqueRGA, SearchType searchType, List<ArtifactInfoFilter> filters) throws NoSuchRepositoryException {
        if (!this.canHandle(terms)) {
            return IteratorSearchResponse.empty(null);
        }
        return this.m_lucene.searchArtifactClassIterator(terms.get(TERM_CLASSNAME), repositoryId, from, count, hitLimit, searchType, filters);
    }
}

