/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.task;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.scheduling.AbstractNexusTask;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.nexus.scheduling.NexusTask;
import org.sonatype.nexus.yum.YumRegistry;
import org.sonatype.nexus.yum.YumRepository;
import org.sonatype.nexus.yum.internal.MetadataProcessor;
import org.sonatype.nexus.yum.internal.RepoMD;
import org.sonatype.nexus.yum.internal.RepositoryUtils;
import org.sonatype.nexus.yum.internal.YumRepositoryImpl;
import org.sonatype.nexus.yum.internal.task.CommandLineExecutor;
import org.sonatype.scheduling.ScheduledTask;
import org.sonatype.scheduling.TaskState;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named(value="MergeMetadataTask")
public class MergeMetadataTask
extends AbstractNexusTask<YumRepository> {
    private static final Logger log = LoggerFactory.getLogger(MergeMetadataTask.class);
    public static final String ID = "MergeMetadataTask";
    private GroupRepository groupRepository;
    private final YumRegistry yumRegistry;
    private final CommandLineExecutor commandLineExecutor;

    @Inject
    public MergeMetadataTask(EventBus eventBus, YumRegistry yumRegistry, CommandLineExecutor commandLineExecutor) {
        super(eventBus, null);
        this.yumRegistry = (YumRegistry)Preconditions.checkNotNull((Object)yumRegistry);
        this.commandLineExecutor = (CommandLineExecutor)Preconditions.checkNotNull((Object)commandLineExecutor);
    }

    public void setGroupRepository(GroupRepository groupRepository) {
        this.groupRepository = groupRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected YumRepository doRun() throws Exception {
        if (this.isValidRepository()) {
            this.deleteYumTempDirs();
            File repoBaseDir = RepositoryUtils.getBaseDir((Repository)this.groupRepository);
            RepositoryItemUid groupRepoMdUid = this.groupRepository.createUid("/repodata/repomd.xml");
            try {
                groupRepoMdUid.getLock().lock(Action.update);
                List<File> memberReposBaseDirs = this.getBaseDirsOfMemberRepositories();
                if (memberReposBaseDirs.size() > 1) {
                    log.debug("Merging repository group '{}' out of {}", (Object)this.groupRepository.getId(), memberReposBaseDirs);
                    this.commandLineExecutor.exec(this.buildCommand(repoBaseDir, memberReposBaseDirs));
                    MetadataProcessor.processMergedMetadata((Repository)this.groupRepository, memberReposBaseDirs);
                    log.debug("Group repository '{}' merged", (Object)this.groupRepository.getId());
                } else {
                    File groupRepodata = new File(repoBaseDir, "repodata");
                    FileUtils.deleteQuietly((File)groupRepodata);
                    if (memberReposBaseDirs.size() == 1) {
                        log.debug("Copying Yum metadata from {} to group repository {}", (Object)memberReposBaseDirs.get(0), (Object)this.groupRepository.getId());
                        FileUtils.copyDirectory((File)new File(memberReposBaseDirs.get(0), "repodata"), (File)groupRepodata);
                    }
                }
            }
            finally {
                groupRepoMdUid.getLock().unlock();
            }
            this.deleteYumTempDirs();
            return new YumRepositoryImpl(repoBaseDir, this.groupRepository.getId(), null);
        }
        return null;
    }

    private List<File> getBaseDirsOfMemberRepositories() throws Exception {
        ArrayList<File> baseDirs = new ArrayList<File>();
        for (Repository memberRepository : this.groupRepository.getMemberRepositories()) {
            log.trace("Looking up latest Yum metadata in {} member of {}", (Object)memberRepository.getId(), (Object)this.groupRepository.getId());
            StorageItem repomdItem = null;
            try {
                log.trace("Retrieving {}:{}", (Object)memberRepository.getId(), (Object)"/repodata/repomd.xml");
                repomdItem = memberRepository.retrieveItem(new ResourceStoreRequest("/repodata/repomd.xml"));
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
            if (repomdItem == null || !(repomdItem instanceof StorageFileItem)) continue;
            try (InputStream in = ((StorageFileItem)repomdItem).getInputStream();){
                RepoMD repomd = new RepoMD(in);
                for (String location : repomd.getLocations()) {
                    String retrieveLocation = "/" + location;
                    if (retrieveLocation.matches("/repodata/.*\\.sqlite\\.bz2")) continue;
                    log.trace("Retrieving {}:{}", (Object)memberRepository.getId(), (Object)retrieveLocation);
                    memberRepository.retrieveItem(new ResourceStoreRequest(retrieveLocation));
                }
            }
            baseDirs.add(RepositoryUtils.getBaseDir(memberRepository).getCanonicalFile());
        }
        return baseDirs;
    }

    private void deleteYumTempDirs() throws IOException {
        final String yumTmpDirPrefix = "yum-" + System.getProperty("user.name");
        File tmpDir = new File("/var/tmp");
        if (tmpDir.exists()) {
            File[] yumTmpDirs;
            for (File yumTmpDir : yumTmpDirs = tmpDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(yumTmpDirPrefix);
                }
            })) {
                log.debug("Deleting yum temp dir : {}", (Object)yumTmpDir);
                FileUtils.deleteQuietly((File)yumTmpDir);
            }
        }
    }

    public boolean allowConcurrentExecution(Map<String, List<ScheduledTask<?>>> activeTasks) {
        if (activeTasks.containsKey(ID)) {
            for (ScheduledTask<?> scheduledTask : activeTasks.get(ID)) {
                if (!TaskState.RUNNING.equals((Object)scheduledTask.getTaskState()) || !this.conflictsWith((MergeMetadataTask)((Object)scheduledTask.getTask()))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean conflictsWith(MergeMetadataTask task) {
        return task.getGroupRepository() != null && this.getGroupRepository() != null && task.getGroupRepository().getId().equals(this.getGroupRepository().getId());
    }

    protected String getAction() {
        return "MERGE_YUM_METADATA";
    }

    protected String getMessage() {
        return String.format("Merging Yum metadata in repository '%s'", this.groupRepository.getId());
    }

    public GroupRepository getGroupRepository() {
        return this.groupRepository;
    }

    private boolean isValidRepository() {
        return this.groupRepository != null && !this.groupRepository.getMemberRepositories().isEmpty();
    }

    private String buildCommand(File repoBaseDir, List<File> memberRepoBaseDirs) throws MalformedURLException, URISyntaxException {
        StringBuilder repos = new StringBuilder();
        for (File memberRepoBaseDir : memberRepoBaseDirs) {
            repos.append(" --repo=");
            repos.append(memberRepoBaseDir.toURI().toASCIIString());
        }
        return String.format("%s --no-database %s -o %s", this.yumRegistry.getMergerepoPath(), repos.toString(), repoBaseDir.getAbsolutePath());
    }

    public static ScheduledTask<YumRepository> createTaskFor(NexusScheduler nexusScheduler, GroupRepository groupRepository) {
        MergeMetadataTask task = (MergeMetadataTask)((Object)nexusScheduler.createTaskInstance(MergeMetadataTask.class));
        task.setGroupRepository(groupRepository);
        return nexusScheduler.submit(ID, (NexusTask)task);
    }
}

