/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.task;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.routing.Manager;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.scheduling.AbstractNexusTask;
import org.sonatype.nexus.util.file.DirSupport;
import org.sonatype.nexus.yum.Yum;
import org.sonatype.nexus.yum.YumGroup;
import org.sonatype.nexus.yum.YumRegistry;
import org.sonatype.nexus.yum.YumRepository;
import org.sonatype.nexus.yum.internal.ListFileFactory;
import org.sonatype.nexus.yum.internal.RepositoryUtils;
import org.sonatype.nexus.yum.internal.RpmListWriter;
import org.sonatype.nexus.yum.internal.RpmScanner;
import org.sonatype.nexus.yum.internal.YumRepositoryImpl;
import org.sonatype.nexus.yum.internal.task.CommandLineExecutor;
import org.sonatype.nexus.yum.internal.task.TaskAlreadyScheduledException;
import org.sonatype.scheduling.ScheduledTask;
import org.sonatype.scheduling.TaskState;
import org.sonatype.scheduling.schedules.RunNowSchedule;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named(value="GenerateMetadataTask")
public class GenerateMetadataTask
extends AbstractNexusTask<YumRepository>
implements ListFileFactory {
    public static final String ID = "GenerateMetadataTask";
    private static final String PACKAGE_FILE_DIR_NAME = ".packageFiles";
    private static final String CACHE_DIR_PREFIX = ".cache-";
    private static final Logger LOG = LoggerFactory.getLogger(GenerateMetadataTask.class);
    public static final String PARAM_REPO_ID = "repoId";
    public static final String PARAM_RPM_DIR = "rpmDir";
    public static final String PARAM_REPO_DIR = "repoDir";
    public static final String PARAM_VERSION = "version";
    public static final String PARAM_ADDED_FILES = "addedFiles";
    public static final String PARAM_SINGLE_RPM_PER_DIR = "singleRpmPerDir";
    public static final String PARAM_FORCE_FULL_SCAN = "forceFullScan";
    public static final String PARAM_YUM_GROUPS_DEFINITION_FILE = "yumGroupsDefinitionFile";
    private final RepositoryRegistry repositoryRegistry;
    private final RpmScanner scanner;
    private final YumRegistry yumRegistry;
    private final Manager routingManager;
    private final CommandLineExecutor commandLineExecutor;

    @Inject
    public GenerateMetadataTask(EventBus eventBus, RepositoryRegistry repositoryRegistry, YumRegistry yumRegistry, RpmScanner scanner, Manager routingManager, CommandLineExecutor commandLineExecutor) {
        super(eventBus, null);
        this.yumRegistry = (YumRegistry)Preconditions.checkNotNull((Object)yumRegistry);
        this.scanner = (RpmScanner)Preconditions.checkNotNull((Object)scanner);
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
        this.routingManager = (Manager)Preconditions.checkNotNull((Object)routingManager);
        this.commandLineExecutor = (CommandLineExecutor)Preconditions.checkNotNull((Object)commandLineExecutor);
        this.getParameters().put(PARAM_SINGLE_RPM_PER_DIR, Boolean.toString(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected YumRepository doRun() throws Exception {
        String repositoryId = this.getRepositoryId();
        if (!StringUtils.isEmpty((String)repositoryId)) {
            Preconditions.checkState((boolean)this.yumRegistry.isRegistered(repositoryId), (Object)"Metadata regeneration can only be run on repositories that have an enabled 'Yum: Generate Metadata' capability");
            Yum yum = this.yumRegistry.get(repositoryId);
            Preconditions.checkState((boolean)yum.getNexusRepository().getRepositoryKind().isFacetAvailable(HostedRepository.class), (Object)"Metadata generation can only be run on hosted repositories");
        }
        this.setDefaults();
        Repository repository = this.findRepository();
        RepositoryItemUid mdUid = repository.createUid("/repodata/repomd.xml");
        try {
            mdUid.getLock().lock(Action.update);
            LOG.debug("Generating Yum-Repository for '{}' ...", (Object)this.getRpmDir());
            try {
                if (this.shouldForceFullScan()) {
                    DirSupport.deleteIfExists((Path)this.getCacheDir().toPath());
                }
                DirSupport.mkdir((Path)this.getRepoDir().toPath());
                File rpmListFile = this.createRpmListFile();
                this.commandLineExecutor.exec(this.buildCreateRepositoryCommand(rpmListFile));
            }
            catch (IOException e) {
                LOG.warn("Yum metadata generation failed", (Throwable)e);
                throw new IOException("Yum metadata generation failed", e);
            }
        }
        finally {
            mdUid.getLock().unlock();
        }
        Thread.sleep(100L);
        MavenRepository mavenRepository = (MavenRepository)repository.adaptToFacet(MavenRepository.class);
        if (mavenRepository != null) {
            try {
                this.routingManager.forceUpdatePrefixFile(mavenRepository);
            }
            catch (Exception e) {
                this.logger.warn("Could not update Whitelist for repository '{}'", (Object)mavenRepository, (Object)e);
            }
        }
        this.regenerateMetadataForGroups();
        return new YumRepositoryImpl(this.getRepoDir(), repositoryId, this.getVersion());
    }

    protected void setDefaults() throws MalformedURLException, URISyntaxException {
        Repository repository = this.findRepository();
        if (StringUtils.isBlank((String)this.getRpmDir()) && repository != null) {
            this.setRpmDir(RepositoryUtils.getBaseDir(repository).getAbsolutePath());
        }
        if (StringUtils.isBlank((String)this.getParameter(PARAM_REPO_DIR)) && StringUtils.isNotBlank((String)this.getRpmDir())) {
            this.setRepoDir(new File(this.getRpmDir()));
        }
    }

    private Repository findRepository() {
        try {
            return this.repositoryRegistry.getRepository(this.getRepositoryId());
        }
        catch (NoSuchRepositoryException e) {
            return null;
        }
    }

    protected String getAction() {
        return "GENERATE_YUM_METADATA";
    }

    protected String getMessage() {
        return String.format("Generate Yum metadata of repository '%s'", this.getRepositoryId());
    }

    public boolean allowConcurrentExecution(Map<String, List<ScheduledTask<?>>> activeTasks) {
        if (activeTasks.containsKey(ID)) {
            int activeRunningTasks = 0;
            for (ScheduledTask<?> scheduledTask : activeTasks.get(ID)) {
                if (!TaskState.RUNNING.equals((Object)scheduledTask.getTaskState())) continue;
                if (this.conflictsWith((GenerateMetadataTask)((Object)scheduledTask.getTask()))) {
                    return false;
                }
                ++activeRunningTasks;
            }
            return activeRunningTasks < this.yumRegistry.maxNumberOfParallelThreads();
        }
        return true;
    }

    public boolean allowConcurrentSubmission(Map<String, List<ScheduledTask<?>>> activeTasks) {
        if (activeTasks.containsKey(ID)) {
            for (ScheduledTask<?> scheduledTask : activeTasks.get(ID)) {
                if (!this.isSubmitted(scheduledTask) || !this.conflictsWith((GenerateMetadataTask)((Object)scheduledTask.getTask())) || !(scheduledTask.getSchedule() instanceof RunNowSchedule)) continue;
                throw new TaskAlreadyScheduledException(scheduledTask, "Found same task in scheduler queue.");
            }
        }
        return true;
    }

    private boolean isSubmitted(ScheduledTask<?> scheduledTask) {
        return TaskState.SUBMITTED.equals((Object)scheduledTask.getTaskState()) || TaskState.SLEEPING.equals((Object)scheduledTask.getTaskState());
    }

    private void regenerateMetadataForGroups() {
        if (StringUtils.isBlank((String)this.getVersion())) {
            try {
                Repository repository = this.repositoryRegistry.getRepository(this.getRepositoryId());
                for (GroupRepository groupRepository : this.repositoryRegistry.getGroupsOfRepository(repository)) {
                    Yum yum = this.yumRegistry.get(groupRepository.getId());
                    if (yum == null || !(yum instanceof YumGroup)) continue;
                    ((YumGroup)yum).markDirty();
                }
            }
            catch (NoSuchRepositoryException e) {
                this.logger.warn("Repository '{}' does not exist anymore. Backing out from triggering group merge for it.", (Object)this.getRepositoryId());
            }
        }
    }

    private boolean conflictsWith(GenerateMetadataTask task) {
        if (StringUtils.equals((String)this.getRepositoryId(), (String)task.getRepositoryId())) {
            return StringUtils.equals((String)this.getVersion(), (String)task.getVersion());
        }
        return false;
    }

    private File createRpmListFile() throws IOException {
        return new RpmListWriter(new File(this.getRpmDir()), this.getAddedFiles(), this.getVersion(), this.isSingleRpmPerDirectory(), this.shouldForceFullScan(), this, this.scanner).writeList();
    }

    private String getRepositoryIdVersion() {
        return this.getRepositoryId() + (StringUtils.isNotBlank((String)this.getVersion()) ? "-version-" + this.getVersion() : "");
    }

    private String buildCreateRepositoryCommand(File packageList) {
        StringBuilder commandLine = new StringBuilder();
        commandLine.append(this.yumRegistry.getCreaterepoPath());
        if (!this.shouldForceFullScan()) {
            commandLine.append(" --update");
        }
        commandLine.append(" --verbose --no-database");
        commandLine.append(" --outputdir ").append(this.getRepoDir().getAbsolutePath());
        commandLine.append(" --pkglist ").append(packageList.getAbsolutePath());
        commandLine.append(" --cachedir ").append(this.createCacheDir().getAbsolutePath());
        String yumGroupsDefinitionFile = this.getYumGroupsDefinitionFile();
        if (yumGroupsDefinitionFile != null) {
            File file = new File(this.getRepoDir().getAbsolutePath(), yumGroupsDefinitionFile);
            String path = file.getAbsolutePath();
            if (file.exists()) {
                if (file.getName().toLowerCase().endsWith(".xml")) {
                    commandLine.append(" --groupfile ").append(path);
                } else {
                    LOG.warn("Yum groups definition file '{}' must have an '.xml' extension, ignoring", (Object)path);
                }
            } else {
                LOG.warn("Yum groups definition file '{}' doesn't exist, ignoring", (Object)path);
            }
        }
        commandLine.append(" ").append(this.getRpmDir());
        return commandLine.toString();
    }

    @Override
    public File getRpmListFile() {
        return new File(this.createPackageDir(), this.getRepositoryId() + ".txt");
    }

    private File createCacheDir() {
        return this.getCacheDir(this.getRepositoryIdVersion());
    }

    private File createPackageDir() {
        return this.getCacheDir(PACKAGE_FILE_DIR_NAME);
    }

    private File getCacheDir(String name) {
        File cacheDir = new File(this.getCacheDir(), name);
        try {
            DirSupport.mkdir((Path)cacheDir.toPath());
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        return cacheDir;
    }

    private File getCacheDir() {
        return new File(this.yumRegistry.getTemporaryDirectory(), CACHE_DIR_PREFIX + this.getRepositoryId());
    }

    @Override
    public File getRpmListFile(String version) {
        return new File(this.createPackageDir(), this.getRepositoryId() + "-" + version + ".txt");
    }

    public String getRepositoryId() {
        return this.getParameter(PARAM_REPO_ID);
    }

    public void setRepositoryId(String repositoryId) {
        this.getParameters().put(PARAM_REPO_ID, repositoryId);
    }

    public String getAddedFiles() {
        return this.getParameter(PARAM_ADDED_FILES);
    }

    public void setAddedFiles(String addedFiles) {
        this.getParameters().put(PARAM_ADDED_FILES, addedFiles);
    }

    public File getRepoDir() {
        return new File(this.getParameter(PARAM_REPO_DIR));
    }

    public void setRepoDir(File repoDir) {
        this.getParameters().put(PARAM_REPO_DIR, repoDir.getAbsolutePath());
    }

    public String getRpmDir() {
        return this.getParameter(PARAM_RPM_DIR);
    }

    public void setRpmDir(String rpmDir) {
        this.getParameters().put(PARAM_RPM_DIR, rpmDir);
    }

    public String getVersion() {
        return this.getParameter(PARAM_VERSION);
    }

    public void setVersion(String version) {
        this.getParameters().put(PARAM_VERSION, version);
    }

    public String getYumGroupsDefinitionFile() {
        return this.getParameter(PARAM_YUM_GROUPS_DEFINITION_FILE);
    }

    public void setYumGroupsDefinitionFile(String file) {
        this.getParameters().put(PARAM_YUM_GROUPS_DEFINITION_FILE, file);
    }

    public boolean isSingleRpmPerDirectory() {
        return Boolean.valueOf(this.getParameter(PARAM_SINGLE_RPM_PER_DIR));
    }

    public boolean shouldForceFullScan() {
        return Boolean.valueOf(this.getParameter(PARAM_FORCE_FULL_SCAN));
    }

    public void setSingleRpmPerDirectory(boolean singleRpmPerDirectory) {
        this.getParameters().put(PARAM_SINGLE_RPM_PER_DIR, Boolean.toString(singleRpmPerDirectory));
    }
}

