/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.task;

import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.gossip.Level;
import org.sonatype.gossip.support.LoggingOutputStream;

@Named
@Singleton
public class CommandLineExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CommandLineExecutor.class);

    public int exec(String command) throws IOException {
        return this.exec(command, (OutputStream)new LoggingOutputStream(LOG, Level.DEBUG), (OutputStream)new LoggingOutputStream(LOG, Level.ERROR));
    }

    public int exec(String command, OutputStream out, OutputStream err) throws IOException {
        LOG.debug("Execute command : {}", (Object)command);
        CommandLine cmdLine = CommandLine.parse((String)command);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(out, err));
        int exitValue = executor.execute(cmdLine);
        LOG.debug("Execution finished with exit code : {}", (Object)exitValue);
        return exitValue;
    }
}

