/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.rest;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Path;
import org.restlet.data.Request;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.sonatype.nexus.yum.Yum;
import org.sonatype.nexus.yum.YumHosted;
import org.sonatype.nexus.yum.YumRegistry;
import org.sonatype.nexus.yum.YumRepository;
import org.sonatype.nexus.yum.internal.rest.AbstractYumRepositoryResource;
import org.sonatype.nexus.yum.internal.rest.UrlPathInterpretation;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;

@Path(value="/yum/repos/{repository}/{version}")
@Named
@Singleton
public class VersionedResource
extends AbstractYumRepositoryResource
implements PlexusResource {
    private static final String YUM_REPO_PREFIX_NAME = "yum/repos";
    private static final String YUM_REPO_PREFIX = "/yum/repos";
    private static final String VERSION_URL_PARAM = "version";
    private static final String REPOSITORY_URL_PARAM = "repository";
    private static final int SEGMENTS_AFTER_REPO_PREFIX = 3;
    public static final String RESOURCE_URI = "/yum/repos/{repository}/{version}";
    private final YumRegistry yumRegistry;

    @Inject
    public VersionedResource(YumRegistry yumRegistry) {
        this.yumRegistry = (YumRegistry)Preconditions.checkNotNull((Object)yumRegistry);
        this.setRequireStrictChecking(false);
    }

    @Override
    protected String getUrlPrefixName() {
        return "yum";
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/yum/repos/**", "authcBasic,perms[nexus:yumVersionedRepositories]");
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    @Override
    protected YumRepository getYumRepository(Request request, UrlPathInterpretation interpretation) throws Exception {
        String repositoryId = request.getAttributes().get(REPOSITORY_URL_PARAM).toString();
        String version = request.getAttributes().get(VERSION_URL_PARAM).toString();
        Yum yum = this.yumRegistry.get(repositoryId);
        if (yum == null) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Couldn't find repository with id : " + repositoryId);
        }
        if (!(yum instanceof YumHosted)) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Repository " + repositoryId + " does not support versions");
        }
        YumHosted yumHosted = (YumHosted)yum;
        String aliasVersion = yumHosted.getVersion(version);
        if (aliasVersion == null) {
            aliasVersion = version;
        }
        return yumHosted.getYumRepository(aliasVersion);
    }

    @Override
    protected int getSegmentCountAfterPrefix() {
        return 3;
    }
}

