/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.rest;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.restlet.data.Request;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.sonatype.nexus.yum.internal.rest.UrlPathInterpretation;

public class UrlPathParser {
    private static final int FIRST_PARAM = 0;
    private static final int SECOND_PARAM = 1;
    private final String segmentPrefix;
    private final int segmentsAfterPrefix;

    public UrlPathParser(String yumRepoPrefixName, int segmentsAfterPrefix) {
        this.segmentPrefix = yumRepoPrefixName;
        this.segmentsAfterPrefix = segmentsAfterPrefix;
    }

    public UrlPathInterpretation parse(Request request) throws ResourceException {
        URL repoUrl;
        List segments = request.getResourceRef().getSegments();
        int yumIndex = segments.indexOf(this.segmentPrefix);
        if (yumIndex < 0) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Prefix '" + this.segmentPrefix + "' not found.");
        }
        try {
            repoUrl = new URL(request.getResourceRef().getHostIdentifier() + "/" + StringUtils.join(segments.subList(0, yumIndex + this.segmentsAfterPrefix + 1), (String)"/"));
        }
        catch (MalformedURLException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
        List lastSegments = segments.subList(yumIndex + this.segmentsAfterPrefix + 1, segments.size());
        if (lastSegments.contains("..")) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Requests with '..' are not allowed");
        }
        if (lastSegments.isEmpty()) {
            return new UrlPathInterpretation(repoUrl, null, true, true, this.pathToIndex(segments));
        }
        if (((String)lastSegments.get(0)).length() == 0) {
            return new UrlPathInterpretation(repoUrl, null, true);
        }
        if ("repodata".equals(lastSegments.get(0))) {
            if (lastSegments.size() == 1) {
                return new UrlPathInterpretation(repoUrl, "repodata", true, true, this.pathToIndex(segments));
            }
            if (((String)lastSegments.get(1)).length() == 0) {
                return new UrlPathInterpretation(repoUrl, "repodata", true);
            }
            if (lastSegments.size() == 2) {
                return new UrlPathInterpretation(repoUrl, (String)lastSegments.get(0) + "/" + (String)lastSegments.get(1), false);
            }
        }
        return new UrlPathInterpretation(repoUrl, StringUtils.join(lastSegments, (String)"/"), false, false, null);
    }

    private String pathToIndex(List<String> segments) {
        return "/" + StringUtils.join(segments, (String)"/") + "/";
    }
}

