/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.rest;

import java.io.File;
import org.restlet.data.MediaType;
import org.restlet.resource.StringRepresentation;
import org.sonatype.nexus.yum.YumRepository;
import org.sonatype.nexus.yum.internal.rest.UrlPathInterpretation;

public class IndexRepresentation
extends StringRepresentation {
    public IndexRepresentation(UrlPathInterpretation interpretation, YumRepository yumRepository) {
        super(IndexRepresentation.generateRepoIndex(yumRepository, interpretation));
        this.setMediaType(MediaType.TEXT_HTML);
    }

    private static CharSequence generateRepoIndex(YumRepository yumRepository, UrlPathInterpretation interpretation) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html><head><title>File list</title></head><body><ul>");
        File directory = yumRepository.resolvePath(interpretation.getPath());
        IndexRepresentation.appendFiles(builder, directory.listFiles());
        builder.append("</ul></html>");
        return builder.toString();
    }

    private static void appendFiles(StringBuilder builder, File[] files) {
        for (File file : files) {
            String name = file.getName();
            if (file.isDirectory()) {
                name = name + "/";
            }
            builder.append(String.format("<li><a href=\"%s\">%s</a></li>", name, name));
        }
    }
}

